/*
 * Decompiled with CFR 0.152.
 */
package com.github.mengweijin.generator.config;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.generator.config.FileOutConfig;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import java.io.File;

public class CustomerFileOutConfig
extends FileOutConfig {
    private String outputDir;
    private String outputPackage;

    public CustomerFileOutConfig(String templatePath, String outputDir, String outputPackage) {
        super(templatePath);
        this.outputDir = outputDir;
        this.outputPackage = outputPackage;
    }

    public File outputFile(TableInfo tableInfo) {
        StringBuilder outputPath = new StringBuilder(this.outputDir);
        if (!this.outputDir.endsWith("/") && !this.outputDir.endsWith("\\")) {
            outputPath.append(File.separator);
        }
        if (!StrUtil.isBlank((CharSequence)this.outputPackage)) {
            outputPath.append(this.outputPackage).append(File.separator);
        }
        StringBuilder componentName = new StringBuilder();
        File templateFile = FileUtil.file((String)this.getTemplatePath());
        String[] packageHierarchy = templateFile.getName().split("\\.");
        if ("entity".equalsIgnoreCase(packageHierarchy[0])) {
            outputPath.append(packageHierarchy[0]).append(File.separator);
        } else {
            for (int i = 0; i < packageHierarchy.length - 2; ++i) {
                componentName.append(NamingStrategy.capitalFirst((String)packageHierarchy[i]));
                outputPath.append(packageHierarchy[i].toLowerCase()).append(File.separator);
            }
        }
        outputPath.append(tableInfo.getEntityName()).append((CharSequence)componentName);
        String path = StrUtil.replace((CharSequence)outputPath.toString(), (CharSequence)".", (CharSequence)"/");
        return new File(path + "." + packageHierarchy[packageHierarchy.length - 2]);
    }
}

