/*
 * Decompiled with CFR 0.152.
 */
package com.github.mengweijin.generator.config;

import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.github.mengweijin.generator.entity.IdField;
import com.github.mengweijin.generator.entity.Parameters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomerInjectionConfig
extends InjectionConfig {
    private static final Logger log = LoggerFactory.getLogger(CustomerInjectionConfig.class);
    private Parameters parameters;

    public CustomerInjectionConfig(Parameters parameters) {
        this.parameters = parameters;
    }

    public void prepareObjectMap(Map<String, Object> objectMap) {
        objectMap.remove("package");
        objectMap.put("parameters", this.parameters);
        objectMap.put("idField", this.getIdField((TableInfo)objectMap.get("table")));
        objectMap.put("allFieldList", this.handleAllFieldList((TableInfo)objectMap.get("table")));
        log.info("Beetl parameter map: {}", objectMap);
    }

    private IdField getIdField(TableInfo tableInfo) {
        TableField tableField = tableInfo.getFields().stream().filter(TableField::isKeyFlag).findFirst().orElse(null);
        IdField idField = new IdField();
        if (tableField != null) {
            idField.setColumnName(tableField.getName());
            idField.setPropertyName(tableField.getPropertyName());
            idField.setPropertyType(tableField.getColumnType().getType());
        }
        return idField;
    }

    private List<TableField> handleAllFieldList(TableInfo tableInfo) {
        List fieldList = tableInfo.getFields();
        List commonFields = tableInfo.getCommonFields();
        ArrayList<TableField> allList = new ArrayList<TableField>();
        allList.addAll(fieldList);
        allList.addAll(commonFields);
        return allList;
    }
}

