/*
 * Decompiled with CFR 0.152.
 */
package com.github.mengweijin.generator.factory;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.FileOutConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.builder.GeneratorBuilder;
import com.baomidou.mybatisplus.generator.config.rules.DateType;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.github.mengweijin.generator.config.CustomerDataSource;
import com.github.mengweijin.generator.config.CustomerFileOutConfig;
import com.github.mengweijin.generator.config.CustomerInjectionConfig;
import com.github.mengweijin.generator.entity.DbInfo;
import com.github.mengweijin.generator.entity.Parameters;
import com.github.mengweijin.generator.entity.ProjectInfo;
import com.github.mengweijin.generator.util.DbInfoUtils;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigFactory {
    private static final Logger log = LoggerFactory.getLogger(ConfigFactory.class);
    private ProjectInfo projectInfo;
    private Parameters parameters;
    private static final ConfigFactory configFactory = new ConfigFactory();

    private ConfigFactory() {
    }

    public static ConfigFactory getInstance(ProjectInfo projectInfo) {
        configFactory.setProjectInfo(projectInfo);
        configFactory.setParameters(projectInfo.getParameters());
        return configFactory;
    }

    public DataSourceConfig getDataSourceConfig() {
        DbInfo dbInfo = DbInfoUtils.getDbInfo(this.projectInfo);
        CustomerDataSource dataSource = new CustomerDataSource(dbInfo.getUrl(), dbInfo.getUsername(), dbInfo.getPassword());
        return new DataSourceConfig.Builder((DataSource)dataSource).build();
    }

    public GlobalConfig getGlobalConfig() {
        return GeneratorBuilder.globalConfigBuilder().fileOverride(true).openDir(false).kotlin(false).swagger2(false).outputDir(FileUtil.file((File)this.projectInfo.getBaseDir(), (String)"target/code-generator/").getAbsolutePath()).author(this.parameters.getAuthor()).dateType(DateType.TIME_PACK).commentDate("yyyy-MM-dd").build();
    }

    public PackageConfig getPackageConfig() {
        return new PackageConfig.Builder().parent(this.parameters.getOutputPackage()).build();
    }

    public TemplateConfig getTemplateConfig() {
        return new TemplateConfig.Builder().disable().build();
    }

    public StrategyConfig getStrategyConfig() {
        return new StrategyConfig.Builder().addInclude(this.trimItemName(this.parameters.getTables())).addTablePrefix(this.trimItemName(this.parameters.getTablePrefix())).entityBuilder().superClass(this.parameters.getSuperEntityClass()).enableSerialVersionUID().enableChainModel().enableLombok().enableTableFieldAnnotation().versionColumnName("version").versionPropertyName("version").logicDeleteColumnName("deleted").logicDeletePropertyName("deleted").naming(NamingStrategy.underline_to_camel).addSuperEntityColumns(this.generateDefaultSuperEntityColumns()).controllerBuilder().superClass(this.parameters.getSuperControllerClass()).enableHyphenStyle().enableRestStyle().serviceBuilder().superServiceClass(this.parameters.getSuperServiceClass()).superServiceImplClass(this.parameters.getSuperServiceImplClass()).mapperBuilder().superClass(this.parameters.getSuperDaoClass()).enableBaseColumnList().enableBaseResultMap().build();
    }

    public InjectionConfig getInjectionConfig(String outputDir, String outputPackage) {
        CustomerInjectionConfig injectionConfig = new CustomerInjectionConfig(this.parameters);
        Parameters parameters = this.projectInfo.getParameters();
        List templateFileList = FileUtil.loopFiles((String)parameters.getTemplateLocation(), file -> file.isFile() && file.getName().toLowerCase().endsWith(parameters.getTemplateType().getSuffix()));
        if (CollectionUtil.isEmpty((Collection)templateFileList)) {
            throw new RuntimeException("No template files found in location " + parameters.getTemplateLocation());
        }
        String message = "Found " + templateFileList.size() + " template files in location " + parameters.getTemplateLocation();
        log.info(message);
        templateFileList.forEach(file -> {
            CustomerFileOutConfig fileOutConfig = new CustomerFileOutConfig(file.getAbsolutePath(), outputDir, outputPackage);
            injectionConfig.addFileOutConfig(new FileOutConfig[]{fileOutConfig});
        });
        return injectionConfig;
    }

    private String[] generateDefaultSuperEntityColumns() {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> cls = Class.forName(this.parameters.getSuperEntityClass(), true, classLoader);
            Field[] declaredFields = ClassUtil.getDeclaredFields(cls);
            return (String[])Arrays.stream(declaredFields).map(field -> StrUtil.toUnderlineCase((CharSequence)field.getName())).toArray(String[]::new);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private String[] trimItemName(String[] items) {
        if (items == null) {
            return null;
        }
        return (String[])Arrays.stream(items).map(String::trim).toArray(String[]::new);
    }

    public void setProjectInfo(ProjectInfo projectInfo) {
        this.projectInfo = projectInfo;
    }

    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }
}

