/*
 * Decompiled with CFR 0.152.
 */
package com.github.mengweijin.quickboot.sample.auth.client.controller;

import com.github.mengweijin.quickboot.sample.auth.client.entity.User;
import com.github.mengweijin.quickboot.sample.auth.client.service.UserService;
import java.io.Serializable;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/user"})
public class UserController {
    private static final Logger log = LoggerFactory.getLogger(UserController.class);
    @Autowired
    private UserService userService;

    @GetMapping(value={"/{id}"})
    public User getById(@PathVariable(value="id") Serializable id) {
        return (User)((Object)this.userService.getById(id));
    }

    @PostMapping
    public void add(@Valid @RequestBody User user) {
        this.userService.save((Object)user);
    }

    @PutMapping
    public void update(@Valid @RequestBody User user) {
        this.userService.updateById((Object)user);
    }

    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable(value="id") Serializable id) {
        this.userService.removeById(id);
    }
}

