/*
 * Decompiled with CFR 0.152.
 */
package com.mgnt.lifecycle.management.backgroundrunner;

import com.mgnt.lifecycle.management.BaseEntity;
import com.mgnt.lifecycle.management.backgroundrunner.BackgroundRunnable;
import com.mgnt.lifecycle.management.backgroundrunner.BackgroundRunnableFactory;
import com.mgnt.utils.TextUtils;
import com.mgnt.utils.entities.TimeInterval;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseBackgroundRunnable
extends BaseEntity<BaseBackgroundRunnable>
implements BackgroundRunnable {
    private static final String FACTORY_TYPE = BaseBackgroundRunnable.class.getSimpleName();
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseBackgroundRunnable.class);
    private boolean initialized = false;

    public BaseBackgroundRunnable() {
        super(FACTORY_TYPE);
    }

    @PostConstruct
    private void init() {
        this.initParams();
    }

    protected synchronized void initParams() {
        if (!this.isInitialized()) {
            this.initParamsForSpecificImplementation();
            this.setInitialized(true);
        }
    }

    protected abstract void initParamsForSpecificImplementation();

    @Override
    public void initTimeIntervalParam(String valueStr, TimeInterval defaultValue, String propertyName) {
        if (StringUtils.isNotBlank((CharSequence)valueStr)) {
            try {
                TimeInterval timeInterval = TextUtils.parseStringToTimeInterval(valueStr);
                this.setParamValue(timeInterval, propertyName);
            }
            catch (IllegalArgumentException iae) {
                LOGGER.error("Error occurred while parsing time interval string: '{}'{}", (Object)valueStr, (Object)TextUtils.getStacktrace(iae));
                this.setParamValue(defaultValue, propertyName);
            }
        } else {
            this.setParamValue(defaultValue, propertyName);
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    static {
        BaseBackgroundRunnable.init(FACTORY_TYPE, BackgroundRunnableFactory.getFactoryInstance());
    }
}

