/*
 * Decompiled with CFR 0.152.
 */
package com.mgnt.lifecycle.management.example;

import com.mgnt.lifecycle.management.BaseEntity;
import com.mgnt.lifecycle.management.example.InfoFormatter;
import com.mgnt.lifecycle.management.example.InfoFormatterFactory;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseInfoFormatter
extends BaseEntity<BaseInfoFormatter>
implements InfoFormatter {
    private static final String FACTORY_TYPE = BaseInfoFormatter.class.getSimpleName();

    public BaseInfoFormatter() {
        super(FACTORY_TYPE);
    }

    public BaseInfoFormatter(String customName) {
        super(FACTORY_TYPE, customName);
    }

    protected boolean isMessageValid(String messageContent) {
        return StringUtils.isNotEmpty((CharSequence)messageContent);
    }

    @Override
    public String formatMessage(String messageContent) {
        String result = null;
        if (this.isMessageValid(messageContent)) {
            result = this.doFormatMessage(messageContent);
        }
        return result;
    }

    protected abstract String doFormatMessage(String var1);

    static {
        BaseInfoFormatter.init(FACTORY_TYPE, InfoFormatterFactory.getFactoryInstance());
    }
}

