/*
 * Decompiled with CFR 0.152.
 */
package com.mgnt.lifecycle.management.httpclient;

import com.mgnt.utils.TextUtils;
import com.mgnt.utils.entities.TimeInterval;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class HttpClient {
    private static final String CONTENT_TYPE_HEADER_KEY = "Content-Type";
    private Map<String, String> requestPropertiesMap = new HashMap<String, String>();
    private String connectionUrl;
    private int lastResponseCode = -1;
    private String lastResponseMessage = null;
    private TimeInterval connectTimeout = new TimeInterval(0L, TimeUnit.MILLISECONDS);
    private TimeInterval readTimeout = new TimeInterval(0L, TimeUnit.MILLISECONDS);

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public String sendHttpRequest(HttpMethod callMethod) throws IOException {
        return this.sendHttpRequest(this.getConnectionUrl(), callMethod, null);
    }

    public String sendHttpRequest(String requestUrl, HttpMethod callMethod) throws IOException {
        return this.sendHttpRequest(requestUrl, callMethod, null);
    }

    public String sendHttpRequest(HttpMethod callMethod, String data) throws IOException {
        return this.sendHttpRequest(this.getConnectionUrl(), callMethod, data);
    }

    public String sendHttpRequest(String requestUrl, HttpMethod callMethod, String data) throws IOException {
        HttpURLConnection connection = this.sendRequest(requestUrl, callMethod, data);
        String response = this.readResponse(connection);
        this.setLastResponseCode(connection.getResponseCode());
        this.setLastResponseMessage(connection.getResponseMessage());
        connection.disconnect();
        return response;
    }

    public ByteBuffer sendHttpRequestForBinaryResponse(HttpMethod callMethod) throws IOException {
        return this.sendHttpRequestForBinaryResponse(this.getConnectionUrl(), callMethod, null);
    }

    public ByteBuffer sendHttpRequestForBinaryResponse(String requestUrl, HttpMethod callMethod) throws IOException {
        return this.sendHttpRequestForBinaryResponse(requestUrl, callMethod, null);
    }

    public ByteBuffer sendHttpRequestForBinaryResponse(HttpMethod callMethod, String data) throws IOException {
        return this.sendHttpRequestForBinaryResponse(this.getConnectionUrl(), callMethod, data);
    }

    public ByteBuffer sendHttpRequestForBinaryResponse(String requestUrl, HttpMethod callMethod, String data) throws IOException {
        HttpURLConnection connection = this.sendRequest(requestUrl, callMethod, data);
        ByteBuffer response = this.readBinaryResponse(connection);
        this.setLastResponseCode(connection.getResponseCode());
        this.setLastResponseMessage(connection.getResponseMessage());
        connection.disconnect();
        return response;
    }

    public String getContentType() {
        String contentType = this.requestPropertiesMap.get(CONTENT_TYPE_HEADER_KEY);
        if (StringUtils.isBlank((CharSequence)contentType) && StringUtils.isNotBlank((CharSequence)(contentType = this.getDefaultContentType()))) {
            this.requestPropertiesMap.put(CONTENT_TYPE_HEADER_KEY, contentType);
        }
        return contentType;
    }

    public void setRequestProperty(String propertyName, String value) {
        if (StringUtils.isNotBlank((CharSequence)propertyName)) {
            this.requestPropertiesMap.put(propertyName, value);
        }
    }

    public String removeRequestProperty(String propertyName) {
        String result = null;
        if (StringUtils.isNotBlank((CharSequence)propertyName)) {
            result = this.requestPropertiesMap.remove(propertyName);
        }
        return result;
    }

    public void clearAllRequestProperties() {
        this.requestPropertiesMap.clear();
    }

    public void setContentType(String contentType) {
        this.requestPropertiesMap.put(CONTENT_TYPE_HEADER_KEY, contentType);
    }

    public int getLastResponseCode() {
        return this.lastResponseCode;
    }

    public String getLastResponseMessage() {
        return this.lastResponseMessage;
    }

    public TimeInterval getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(TimeInterval connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setConnectTimeout(String timeIntervalStr) throws IllegalArgumentException {
        this.setConnectTimeout(TextUtils.parseStringToTimeInterval(timeIntervalStr));
    }

    public void setConnectTimeout(long timeValue, TimeUnit timeUnit) throws IllegalArgumentException {
        if (timeValue < 0L) {
            throw new IllegalArgumentException("Negative value for timeout");
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException("Null Time Unit value for timeout");
        }
        this.setConnectTimeout(new TimeInterval(timeValue, timeUnit));
    }

    public TimeInterval getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(TimeInterval readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setReadTimeout(String timeIntervalStr) throws IllegalArgumentException {
        this.setReadTimeout(TextUtils.parseStringToTimeInterval(timeIntervalStr));
    }

    public void setReadTimeout(long timeValue, TimeUnit timeUnit) throws IllegalArgumentException {
        if (timeValue < 0L) {
            throw new IllegalArgumentException("Negative value for timeout");
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException("Null Time Unit value for timeout");
        }
        this.setReadTimeout(new TimeInterval(timeValue, timeUnit));
    }

    protected HttpURLConnection openHttpUrlConnection(String url, HttpMethod method) throws IOException {
        return this.openHttpUrlConnection(url, method, false);
    }

    protected HttpURLConnection openHttpUrlConnection(String url, HttpMethod method, boolean doOutput) throws IOException {
        URL requestUrl = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)requestUrl.openConnection();
        this.setConnectionTimeout(connection);
        this.setReadTimeout(connection);
        connection.setDoOutput(doOutput);
        connection.setRequestMethod(method.toString());
        for (String requestProperty : this.requestPropertiesMap.keySet()) {
            connection.setRequestProperty(requestProperty, this.requestPropertiesMap.get(requestProperty));
        }
        return connection;
    }

    protected String getDefaultContentType() {
        return null;
    }

    private void setLastResponseCode(int lastResponseCode) {
        this.lastResponseCode = lastResponseCode;
    }

    private void setLastResponseMessage(String lastResponseMessage) {
        this.lastResponseMessage = lastResponseMessage;
    }

    private String readResponse(HttpURLConnection connection) throws IOException {
        String response = "";
        try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            response = sb.toString();
        }
        return response;
    }

    private ByteBuffer readBinaryResponse(HttpURLConnection connection) throws IOException {
        LinkedList<ByteBuffer> content = new LinkedList<ByteBuffer>();
        int totalLength = 0;
        InputStream is = connection.getInputStream();
        Object object = null;
        try {
            byte[] buff;
            int length;
            while ((length = is.read(buff = new byte[8192])) >= 0) {
                content.add(ByteBuffer.wrap(buff, 0, length));
                totalLength += length;
            }
        }
        catch (Throwable buff) {
            object = buff;
            throw buff;
        }
        finally {
            if (is != null) {
                if (object != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable buff) {
                        ((Throwable)object).addSuppressed(buff);
                    }
                } else {
                    is.close();
                }
            }
        }
        ByteBuffer result = ByteBuffer.allocate(totalLength);
        for (ByteBuffer byteBuffer : content) {
            result.put(byteBuffer);
        }
        return result;
    }

    private HttpURLConnection sendRequest(String url, HttpMethod method, String data) throws IOException {
        boolean doOutput = StringUtils.isNotBlank((CharSequence)data);
        HttpURLConnection httpURLConnection = this.openHttpUrlConnection(url, method, doOutput);
        if (doOutput) {
            try (DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());){
                dataOutputStream.write(StandardCharsets.UTF_8.encode(data).array());
                dataOutputStream.flush();
            }
        }
        return httpURLConnection;
    }

    private HttpURLConnection setConnectionTimeout(HttpURLConnection connection) {
        int connectionTimeoutMs = Long.valueOf(this.getConnectTimeout().toMillis()).intValue();
        if ((long)connectionTimeoutMs >= 0L) {
            connection.setConnectTimeout(connectionTimeoutMs);
        }
        return connection;
    }

    private HttpURLConnection setReadTimeout(HttpURLConnection connection) {
        int readTimeoutMs = Long.valueOf(this.getReadTimeout().toMillis()).intValue();
        if ((long)readTimeoutMs >= 0L) {
            connection.setReadTimeout(readTimeoutMs);
        }
        return connection;
    }

    public static enum HttpMethod {
        GET,
        PUT,
        POST,
        DELETE,
        HEAD,
        OPTIONS,
        TRACE;

    }
}

