/*
 * Decompiled with CFR 0.152.
 */
package com.mgnt.utils;

import com.mgnt.utils.StringUnicodeEncoderDecoder;
import com.mgnt.utils.entities.TimeInterval;
import com.mgnt.utils.textutils.InvalidVersionFormatException;
import com.mgnt.utils.textutils.Version;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextUtils {
    private static final Logger logger = LoggerFactory.getLogger(TextUtils.class);
    protected static final TimeUnit DEFAULT_TIMEOUT_TIME_UNIT = TimeUnit.MILLISECONDS;
    protected static final String SECONDS_SUFFIX = "s";
    protected static final String MINUTES_SUFFIX = "m";
    protected static final String HOURS_SUFFIX = "h";
    protected static final String DAYS_SUFFIX = "d";
    private static final long INITIAL_PARSING_VALUE = -1L;
    private static String RELEVANT_PACKAGE = null;
    private static final String STANDARD_STAKTRACE_PREFIX = "at ";
    private static final String SKIPPING_LINES_STRING = "\t...";
    private static final String CAUSE_STAKTRACE_PREFIX = "Caused by:";
    private static final String SUPPRESED_STAKTRACE_PREFIX = "Suppressed:";
    private static final String RELEVANT_PACKAGE_SYSTEM_EVIRONMENT_VARIABLE = "MGNT_RELEVANT_PACKAGE";
    private static final String RELEVANT_PACKAGE_SYSTEM_PROPERTY = "mgnt.relevant.package";
    private static final String HTML_NON_BREAKING_SPACE_CHARACTER = StringUnicodeEncoderDecoder.decodeUnicodeSequenceToString("\\u00A0");
    private static final String HTML_NEW_LINE = "<br>";

    private static void initRelevantPackageFromSystemProperty() {
        String relevantPackage = System.getProperty(RELEVANT_PACKAGE_SYSTEM_PROPERTY);
        if (StringUtils.isBlank((CharSequence)relevantPackage)) {
            relevantPackage = System.getenv(RELEVANT_PACKAGE_SYSTEM_EVIRONMENT_VARIABLE);
        }
        if (StringUtils.isNotBlank((CharSequence)relevantPackage)) {
            TextUtils.setRelevantPackage(relevantPackage);
        }
    }

    public static int compareVersions(String ver1, String ver2) throws InvalidVersionFormatException {
        return new Version(ver1).compareTo(new Version(ver2));
    }

    public static int compareVersions(Version ver1, String ver2) throws InvalidVersionFormatException {
        return ver1.compareTo(new Version(ver2));
    }

    public static int compareVersions(String ver1, Version ver2) throws InvalidVersionFormatException {
        return new Version(ver1).compareTo(ver2);
    }

    public static int compareVersions(Version ver1, Version ver2) {
        return ver1.compareTo(ver2);
    }

    public static int parseStringToInt(CharSequence num, int defaultValue, String nullOrEmptyStringErrorMessage, String numberFormatErrorMessage) {
        Integer result = null;
        if (num == null || "".equals(num.toString())) {
            if (nullOrEmptyStringErrorMessage != null && !"".equals(nullOrEmptyStringErrorMessage)) {
                logger.warn(nullOrEmptyStringErrorMessage);
            }
            result = defaultValue;
        } else {
            try {
                result = Integer.parseInt(num.toString());
            }
            catch (NumberFormatException nfe) {
                if (numberFormatErrorMessage != null && !"".equals(numberFormatErrorMessage)) {
                    TextUtils.warn(numberFormatErrorMessage, nfe);
                }
                result = defaultValue;
            }
        }
        return result;
    }

    public static int parseStringToInt(CharSequence num, int defaultValue) {
        return TextUtils.parseStringToInt(num, defaultValue, null, null);
    }

    public static float parseStringToFloat(CharSequence num, float defaultValue, String nullOrEmptyStringErrorMessage, String numberFormatErrorMessage) {
        Float result = null;
        if (num == null || "".equals(num.toString())) {
            if (nullOrEmptyStringErrorMessage != null && !"".equals(nullOrEmptyStringErrorMessage)) {
                logger.warn(nullOrEmptyStringErrorMessage);
            }
            result = Float.valueOf(defaultValue);
        } else {
            try {
                result = Float.valueOf(Float.parseFloat(num.toString()));
            }
            catch (NumberFormatException nfe) {
                if (numberFormatErrorMessage != null && !"".equals(numberFormatErrorMessage)) {
                    TextUtils.warn(numberFormatErrorMessage, nfe);
                }
                result = Float.valueOf(defaultValue);
            }
        }
        return result.floatValue();
    }

    public static float parseStringToFloat(CharSequence num, float defaultValue) {
        return TextUtils.parseStringToFloat(num, defaultValue, null, null);
    }

    public static Byte parseStringToByte(CharSequence num, byte defaultValue, String nullOrEmptyStringErrorMessage, String numberFormatErrorMessage) {
        Byte result = null;
        if (num == null || "".equals(num.toString())) {
            if (nullOrEmptyStringErrorMessage != null && !"".equals(nullOrEmptyStringErrorMessage)) {
                logger.warn(nullOrEmptyStringErrorMessage);
            }
            result = defaultValue;
        } else {
            try {
                result = Byte.parseByte(num.toString());
            }
            catch (NumberFormatException nfe) {
                if (numberFormatErrorMessage != null && !"".equals(numberFormatErrorMessage)) {
                    TextUtils.warn(numberFormatErrorMessage, nfe);
                }
                result = defaultValue;
            }
        }
        return result;
    }

    public static Byte parseStringToByte(CharSequence num, byte defaultValue) {
        return TextUtils.parseStringToByte(num, defaultValue, null, null);
    }

    public static double parseStringToDouble(CharSequence num, double defaultValue, String nullOrEmptyStringErrorMessage, String numberFormatErrorMessage) {
        Double result = null;
        if (num == null || "".equals(num.toString())) {
            if (nullOrEmptyStringErrorMessage != null && !"".equals(nullOrEmptyStringErrorMessage)) {
                logger.warn(nullOrEmptyStringErrorMessage);
            }
            result = defaultValue;
        } else {
            try {
                result = Double.parseDouble(num.toString());
            }
            catch (NumberFormatException nfe) {
                if (numberFormatErrorMessage != null && !"".equals(numberFormatErrorMessage)) {
                    TextUtils.warn(numberFormatErrorMessage, nfe);
                }
                result = defaultValue;
            }
        }
        return result;
    }

    public static double parseStringToDouble(CharSequence num, double defaultValue) {
        return TextUtils.parseStringToDouble(num, defaultValue, null, null);
    }

    public static long parseStringToLong(CharSequence num, long defaultValue, String nullOrEmptyStringErrorMessage, String numberFormatErrorMessage) {
        Long result = null;
        if (num == null || "".equals(num.toString())) {
            if (nullOrEmptyStringErrorMessage != null && !"".equals(nullOrEmptyStringErrorMessage)) {
                logger.warn(nullOrEmptyStringErrorMessage);
            }
            result = defaultValue;
        } else {
            try {
                result = Long.parseLong(num.toString());
            }
            catch (NumberFormatException nfe) {
                if (numberFormatErrorMessage != null && !"".equals(numberFormatErrorMessage)) {
                    TextUtils.warn(numberFormatErrorMessage, nfe);
                }
                result = defaultValue;
            }
        }
        return result;
    }

    public static long parseStringToLong(CharSequence num, long defaultValue) {
        return TextUtils.parseStringToLong(num, defaultValue, null, null);
    }

    public static Short parseStringToShort(CharSequence num, short defaultValue, String nullOrEmptyStringErrorMessage, String numberFormatErrorMessage) {
        Short result = null;
        if (num == null || "".equals(num.toString())) {
            if (nullOrEmptyStringErrorMessage != null && !"".equals(nullOrEmptyStringErrorMessage)) {
                logger.warn(nullOrEmptyStringErrorMessage);
            }
            result = defaultValue;
        } else {
            try {
                result = Short.parseShort(num.toString());
            }
            catch (NumberFormatException nfe) {
                if (numberFormatErrorMessage != null && !"".equals(numberFormatErrorMessage)) {
                    TextUtils.warn(numberFormatErrorMessage, nfe);
                }
                result = defaultValue;
            }
        }
        return result;
    }

    public static Short parseStringToShort(CharSequence num, short defaultValue) {
        return TextUtils.parseStringToShort(num, defaultValue, null, null);
    }

    public static TimeInterval parseStringToTimeInterval(String valueStr) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)valueStr)) {
            throw new IllegalArgumentException("Attempt to parse null or blank String");
        }
        TimeInterval result = new TimeInterval();
        String potentialSuffix = valueStr.substring(valueStr.length() - 1);
        boolean isLetter = Character.isLetter(potentialSuffix.codePointAt(0));
        String valueToParse = isLetter ? valueStr.substring(0, valueStr.length() - 1) : valueStr;
        result.setValue(-1L);
        result = TextUtils.setTimeUnit(isLetter, potentialSuffix, result);
        result = TextUtils.setTimeValue(valueToParse, result);
        return result;
    }

    public static TimeInterval parsingStringToTimeInterval(String valueStr) throws IllegalArgumentException {
        return TextUtils.parseStringToTimeInterval(valueStr);
    }

    public static String getStacktrace(Throwable e, boolean cutTBS, String relevantPackage) {
        ByteArrayOutputStream stacktraceContent = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(stacktraceContent));
        return TextUtils.extractStackTrace(cutTBS, relevantPackage, stacktraceContent);
    }

    public static String getStacktrace(Throwable e, boolean cutTBS) {
        return TextUtils.getStacktrace(e, cutTBS, null);
    }

    public static String getStacktrace(Throwable e) {
        return TextUtils.getStacktrace(e, true, null);
    }

    public static String getStacktrace(Throwable e, String relevantPackage) {
        return TextUtils.getStacktrace(e, true, relevantPackage);
    }

    public static String getStacktrace(CharSequence stacktrace, String relevantPackage) {
        return TextUtils.extractStackTrace(true, relevantPackage, TextUtils.convertToByteArray(stacktrace));
    }

    public static String getStacktrace(CharSequence stacktrace) {
        return TextUtils.extractStackTrace(true, null, TextUtils.convertToByteArray(stacktrace));
    }

    private static ByteArrayOutputStream convertToByteArray(CharSequence stacktrace) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (stacktrace != null) {
            byte[] content = stacktrace.toString().getBytes();
            baos.write(content, 0, content.length);
        }
        return baos;
    }

    private static String extractStackTrace(boolean cutTBS, String relevantPackage, ByteArrayOutputStream stacktraceContent) {
        String relPack;
        StringBuilder result = new StringBuilder("\n");
        String string = relPack = relevantPackage != null && !relevantPackage.isEmpty() ? relevantPackage : RELEVANT_PACKAGE;
        if ((relPack == null || "".equals(relPack)) && cutTBS) {
            cutTBS = false;
            logger.warn("Relevant package was not set for the method. Stacktrace can not be shortened. Returning full stacktrace");
        }
        if (cutTBS) {
            if (stacktraceContent.size() > 0) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(stacktraceContent.toByteArray())));){
                    String line = reader.readLine();
                    while ((line = TextUtils.traverseSingularStacktrace(result, relPack, reader, line)) != null) {
                    }
                }
                catch (IOException ioe) {
                    TextUtils.error("Error occurred while reading and shortening stacktrace of an exception. Printing the original stacktrace", ioe);
                    result.delete(0, result.length()).append(new String(stacktraceContent.toByteArray()));
                }
            }
        } else {
            result.append(new String(stacktraceContent.toByteArray()));
        }
        return result.toString();
    }

    private static String traverseSingularStacktrace(StringBuilder result, String relPack, BufferedReader reader, String line) throws IOException {
        result.append(line).append("\n");
        boolean toBePrinted = true;
        boolean relevantPackageReached = false;
        boolean isCurLineRelevantPack = false;
        boolean skipLineToBePrinted = false;
        while ((line = reader.readLine()) != null) {
            String trimmedLine = line.trim();
            if (trimmedLine.startsWith(STANDARD_STAKTRACE_PREFIX)) {
                isCurLineRelevantPack = trimmedLine.substring(STANDARD_STAKTRACE_PREFIX.length()).startsWith(relPack);
                if (!relevantPackageReached && isCurLineRelevantPack) {
                    relevantPackageReached = true;
                    toBePrinted = true;
                    skipLineToBePrinted = false;
                }
                if (toBePrinted) {
                    result.append(line).append("\n");
                } else if (skipLineToBePrinted) {
                    result.append(SKIPPING_LINES_STRING).append("\n");
                    skipLineToBePrinted = false;
                }
                if (!relevantPackageReached || isCurLineRelevantPack) continue;
                relevantPackageReached = false;
                toBePrinted = false;
                skipLineToBePrinted = true;
                continue;
            }
            if (trimmedLine.startsWith(CAUSE_STAKTRACE_PREFIX) || trimmedLine.startsWith(SUPPRESED_STAKTRACE_PREFIX)) break;
            if (!toBePrinted && !skipLineToBePrinted) continue;
            result.append(line).append("\n");
            skipLineToBePrinted = false;
        }
        return line;
    }

    public static String getRelevantPackage() {
        return RELEVANT_PACKAGE;
    }

    public static void setRelevantPackage(String relevantPackage) {
        RELEVANT_PACKAGE = relevantPackage;
    }

    public static String formatStringToPreserveIndentationForHtml(String rawText) {
        String result = rawText;
        if (StringUtils.isNotEmpty((CharSequence)rawText)) {
            result = rawText.replaceAll(" ", HTML_NON_BREAKING_SPACE_CHARACTER).replaceAll("\n", "<br>\n");
        }
        return result;
    }

    private static void warn(String message, Throwable t) {
        if (RELEVANT_PACKAGE != null && !RELEVANT_PACKAGE.isEmpty()) {
            logger.warn(message + TextUtils.getStacktrace(t));
        } else {
            logger.warn(message, t);
        }
    }

    private static void error(String message, Throwable t) {
        if (RELEVANT_PACKAGE != null && !RELEVANT_PACKAGE.isEmpty()) {
            logger.error(message + TextUtils.getStacktrace(t));
        } else {
            logger.error(message, t);
        }
    }

    private static void debug(String message, Throwable t) {
        if (RELEVANT_PACKAGE != null && !RELEVANT_PACKAGE.isEmpty()) {
            logger.debug(message + TextUtils.getStacktrace(t));
        } else {
            logger.debug(message, t);
        }
    }

    private static void fatal(String message, Throwable t) {
        if (RELEVANT_PACKAGE != null && !RELEVANT_PACKAGE.isEmpty()) {
            logger.error(message + TextUtils.getStacktrace(t));
        } else {
            logger.error(message, t);
        }
    }

    private static void info(String message, Throwable t) {
        if (RELEVANT_PACKAGE != null && !RELEVANT_PACKAGE.isEmpty()) {
            logger.info(message + TextUtils.getStacktrace(t));
        } else {
            logger.info(message, t);
        }
    }

    private static void trace(String message, Throwable t) {
        if (RELEVANT_PACKAGE != null && !RELEVANT_PACKAGE.isEmpty()) {
            logger.trace(message + TextUtils.getStacktrace(t));
        } else {
            logger.trace(message, t);
        }
    }

    private static TimeInterval setTimeValue(String valueToParse, TimeInterval result) {
        if (result.getValue() == -1L) {
            result.setValue(Long.parseLong(valueToParse));
            if (result.getValue() < 1L) {
                throw new IllegalArgumentException("Negative or zero value '" + result.getValue() + "' for time interval is illegal");
            }
        }
        return result;
    }

    private static TimeInterval setTimeUnit(boolean isLetter, String potentialSuffix, TimeInterval result) {
        if (isLetter) {
            result.setTimeUnit(TextUtils.getTimeUnitBySuffix(potentialSuffix));
        } else {
            result.setTimeUnit(DEFAULT_TIMEOUT_TIME_UNIT);
        }
        return result;
    }

    private static TimeUnit getTimeUnitBySuffix(String suffix) {
        TimeUnit result;
        switch (suffix.toLowerCase()) {
            case "s": {
                result = TimeUnit.SECONDS;
                break;
            }
            case "m": {
                result = TimeUnit.MINUTES;
                break;
            }
            case "h": {
                result = TimeUnit.HOURS;
                break;
            }
            case "d": {
                result = TimeUnit.DAYS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Time Unit Suffix " + suffix + " is invalid. Valid values are:\n'" + SECONDS_SUFFIX + "' for seconds \n'" + MINUTES_SUFFIX + "' for minutes \n'" + HOURS_SUFFIX + "' for hours \n'" + DAYS_SUFFIX + "' for days");
            }
        }
        return result;
    }

    static {
        TextUtils.initRelevantPackageFromSystemProperty();
    }
}

