/*
 * Decompiled with CFR 0.152.
 */
package com.mgnt.utils;

import com.mgnt.utils.TimeUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class WebUtils {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int MAX_SUBSEQUENT_FAILURES_LIMIT = 10;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readRequestContentAsByteArray(HttpServletRequest request) throws IOException {
        ArrayList<Byte> resultCollector = null;
        boolean unknownLength = true;
        try (ServletInputStream reader = request.getInputStream();){
            int i;
            int length = request.getContentLength();
            switch (length) {
                case -1: {
                    length = 8192;
                    break;
                }
                case 0: {
                    byte[] byArray = null;
                    return byArray;
                }
                default: {
                    unknownLength = false;
                }
            }
            if (unknownLength) {
                resultCollector = new ArrayList<Byte>(length);
            }
            int totalNumberOfReadBytes = 0;
            byte[] byteBuffer = new byte[length];
            totalNumberOfReadBytes = reader.read(byteBuffer);
            int numberOfReadBytes = totalNumberOfReadBytes;
            if (numberOfReadBytes < 0) {
                byte[] byArray = null;
                return byArray;
            }
            if (!unknownLength && totalNumberOfReadBytes == length) {
                byte[] byArray = byteBuffer;
                return byArray;
            }
            if (unknownLength) {
                for (int i2 = 0; i2 < numberOfReadBytes; ++i2) {
                    resultCollector.add(byteBuffer[i2]);
                }
            }
            int numberOfsubsequentFailures = 0;
            do {
                if ((numberOfReadBytes = !unknownLength ? reader.read(byteBuffer, totalNumberOfReadBytes, length - totalNumberOfReadBytes) : reader.read(byteBuffer)) > 0) {
                    if (numberOfsubsequentFailures > 0) {
                        numberOfsubsequentFailures = 0;
                    }
                    if (unknownLength) {
                        for (i = 0; i < numberOfReadBytes; ++i) {
                            resultCollector.add(byteBuffer[i]);
                        }
                    }
                    totalNumberOfReadBytes += numberOfReadBytes;
                    continue;
                }
                if (++numberOfsubsequentFailures >= 10) {
                    throw new IOException("The reading from the source could not be completed due to unknown error");
                }
                TimeUtils.sleepFor(1L, TimeUnit.MILLISECONDS);
            } while (numberOfReadBytes >= 0);
            if (!unknownLength && totalNumberOfReadBytes < length) {
                throw new IOException("The length of info read is less the declared content length");
            }
            if (unknownLength) {
                byteBuffer = new byte[resultCollector.size()];
                for (i = 0; i < resultCollector.size(); ++i) {
                    byteBuffer[i] = (Byte)resultCollector.get(i);
                }
            }
            byte[] byArray = byteBuffer;
            return byArray;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new IOException("Unexpected error occurred", e);
        }
    }
}

