/*
 * Decompiled with CFR 0.152.
 */
package com.mgnt.utils.textutils;

import com.mgnt.utils.textutils.InvalidVersionFormatException;
import com.mgnt.utils.textutils.VersionComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Version
implements Comparable<Version> {
    private static final String SEPARATOR = ".";
    private static final String SPLIT_SEPARATOR = "\\.";
    private static final VersionComparator COMPARATOR = new VersionComparator();
    private List<Integer> versionNumbers = new ArrayList<Integer>();

    public Version(String verStr) throws InvalidVersionFormatException {
        if (verStr == null || "".equals(verStr)) {
            throw new InvalidVersionFormatException("Null or empty string may not represent a valid vrsion");
        }
        for (String numStr : verStr.trim().split(SPLIT_SEPARATOR, Integer.MAX_VALUE)) {
            try {
                Integer num = Integer.parseInt(numStr);
                if (num < 0) {
                    throw new InvalidVersionFormatException("Version may not contain a negative number");
                }
                this.versionNumbers.add(num);
            }
            catch (NumberFormatException nfe) {
                throw new InvalidVersionFormatException("Version must contain valid numeric values separated by '.'", nfe);
            }
        }
        if (this.versionNumbers.isEmpty()) {
            throw new InvalidVersionFormatException("Blank version error");
        }
    }

    public List<Integer> getVersionNumbers() {
        return Collections.unmodifiableList(this.versionNumbers);
    }

    @Override
    public int compareTo(Version otherVersion) {
        if (otherVersion == null) {
            throw new NullPointerException("Version passed for comparison is null");
        }
        return COMPARATOR.compare(this, otherVersion);
    }

    public String toString() {
        StringBuilder ver = new StringBuilder();
        for (Integer i : this.versionNumbers) {
            ver.append(i).append(SEPARATOR);
        }
        ver.deleteCharAt(ver.length() - 1);
        return ver.toString();
    }

    public int hashCode() {
        return this.versionNumbers.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        return this.versionNumbers.equals(other.versionNumbers);
    }
}

