/*
 * Decompiled with CFR 0.152.
 */
package com.mgnt.utils.textutils;

import com.mgnt.utils.textutils.InvalidVersionFormatException;
import com.mgnt.utils.textutils.InvalidVersionRangeException;
import com.mgnt.utils.textutils.Version;
import java.io.Serializable;
import java.text.MessageFormat;

public class VersionRange
implements Serializable {
    private static final long serialVersionUID = 236297683414697942L;
    private static final String VERSION_DELIMITER = "-";
    private Version _fromVersion;
    private Version _toVersion;

    public VersionRange(Version fromVersion, Version toVersion) throws InvalidVersionRangeException {
        this._fromVersion = fromVersion;
        this._toVersion = toVersion;
        this.validateData();
    }

    public VersionRange(String fromVersion, String toVersion) throws InvalidVersionRangeException, InvalidVersionFormatException {
        this(new Version(fromVersion.trim()), new Version(toVersion.trim()));
    }

    public VersionRange(Version fromVersion, String toVersion) throws InvalidVersionRangeException, InvalidVersionFormatException {
        this(fromVersion, new Version(toVersion.trim()));
    }

    public VersionRange(String fromVersion, Version toVersion) throws InvalidVersionRangeException, InvalidVersionFormatException {
        this(new Version(fromVersion.trim()), toVersion);
    }

    public VersionRange(Version ver) throws InvalidVersionRangeException {
        this(ver, ver);
    }

    public VersionRange(String versionRange) throws InvalidVersionRangeException, InvalidVersionFormatException {
        if (versionRange == null || "".equals(versionRange)) {
            throw new InvalidVersionRangeException("NUll or blank argument");
        }
        String[] versions = versionRange.split(VERSION_DELIMITER, 2);
        if (versions.length == 1) {
            this._fromVersion = this._toVersion = new Version(versions[0].trim());
        } else {
            this._fromVersion = new Version(versions[0].trim());
            this._toVersion = new Version(versions[1].trim());
        }
        this.validateData();
    }

    public Version getFromVersion() {
        return this._fromVersion;
    }

    public Version getToVersion() {
        return this._toVersion;
    }

    public boolean isInRange(Version ver) {
        boolean result = false;
        if (ver != null && this._fromVersion.compareTo(ver) <= 0 && this._toVersion.compareTo(ver) >= 0) {
            result = true;
        }
        return result;
    }

    public boolean isInRange(String ver) throws InvalidVersionFormatException {
        return this.isInRange(new Version(ver));
    }

    public boolean isAboveRange(Version ver) {
        boolean result = false;
        if (ver.compareTo(this.getToVersion()) > 0) {
            result = true;
        }
        return result;
    }

    public boolean isAboveRange(String ver) throws InvalidVersionFormatException {
        return this.isAboveRange(new Version(ver));
    }

    public boolean isBellowRange(Version ver) {
        boolean result = false;
        if (ver.compareTo(this.getFromVersion()) < 0) {
            result = true;
        }
        return result;
    }

    public boolean isBelowRange(String ver) throws InvalidVersionFormatException {
        return this.isBellowRange(new Version(ver));
    }

    public boolean isOverlap(VersionRange otherRange) {
        boolean result = false;
        if (otherRange != null && (this.isInRange(otherRange.getFromVersion()) || this.isInRange(otherRange.getToVersion()))) {
            result = true;
        }
        return result;
    }

    public String toString() {
        return MessageFormat.format("{0} {2} {1}", this._fromVersion.toString(), this._toVersion.toString(), VERSION_DELIMITER);
    }

    private void validateData() throws InvalidVersionRangeException {
        if (this._fromVersion == null || this._toVersion == null) {
            throw new InvalidVersionRangeException("One of the range limits is null");
        }
        if (this._fromVersion.compareTo(this._toVersion) > 0) {
            throw new InvalidVersionRangeException("Lower range limit is greater then upper range limit");
        }
    }
}

