/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.catmvnplugin;

import com.github.mike10004.catmvnplugin.OrderableFileSet;
import com.github.mike10004.catmvnplugin.OrderableFileSetManager;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.stream.Stream;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.model.fileset.FileSet;

@Mojo(name="cat", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
@NotThreadSafe
public class ConcatenateMojo
extends AbstractMojo {
    @Parameter
    private OrderableFileSet[] sources;
    @Parameter
    private File outputFile;
    @Parameter
    private boolean ignoreEmptySourcesList;
    @Parameter(defaultValue="repeat")
    private RepeatedFileStrategy repeatedFileStrategy = RepeatedFileStrategy.repeat;

    private static String toString(FileSet fileset) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("directory", fileset.getDirectory());
        map.put("includes", fileset.getIncludes());
        map.put("excludes", fileset.getExcludes());
        return "FileSet{" + ((Object)map).toString() + "}";
    }

    protected Collection<File> createBucket() {
        return this.repeatedFileStrategy.createBucket();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.sources == null) {
            throw new IllegalStateException("sources filesets not yet set");
        }
        Collection<File> sourceFiles = this.createBucket();
        OrderableFileSetManager fileSetManager = new OrderableFileSetManager();
        this.getLog().debug((CharSequence)(this.sources.length + " sources specified"));
        for (int i = 0; i < this.sources.length; ++i) {
            OrderableFileSet fileset = this.sources[i];
            String filesetDir = fileset.getDirectory();
            if (filesetDir == null) {
                throw new MojoExecutionException("fileset directory not set on fileset at index " + i + ": " + ConcatenateMojo.toString(fileset));
            }
            File parent = new File(filesetDir);
            String[] includedDirs = fileSetManager.getIncludedDirectories(fileset);
            if (includedDirs != null && includedDirs.length > 0) {
                throw new MojoExecutionException("included directories are not supported");
            }
            String[] excludedDirs = fileSetManager.getExcludedDirectories(fileset);
            if (excludedDirs != null && excludedDirs.length > 0) {
                throw new MojoExecutionException("excluded directories are not yet supported");
            }
            String[] includedFiles = fileSetManager.getIncludedFiles(fileset);
            if (!fileset.isIgnoreEmptyIncludedFilesList() && includedFiles.length == 0) {
                throw new MojoExecutionException("fileset at index " + i + " did not yield any files: " + ConcatenateMojo.toString(fileset));
            }
            Stream.of(includedFiles).forEach(p -> {
                File file = new File(parent, (String)p);
                boolean result = sourceFiles.add(file);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("included file " + file + " (Collection.add = " + result + ")"));
                }
            });
        }
        if (!this.ignoreEmptySourcesList && sourceFiles.isEmpty()) {
            throw new MojoExecutionException("filesets did not yield any files; set ignoreEmptySourceList flag to true if this should be ignored");
        }
        try {
            this.writeConcatenated(sourceFiles);
        }
        catch (IOException e) {
            throw new MojoExecutionException("failed to copy source files to destination " + this.outputFile, (Exception)e);
        }
    }

    protected void writeConcatenated(Iterable<File> sourceFiles) throws IOException {
        if (this.outputFile == null) {
            throw new IllegalStateException("output file not set");
        }
        Files.createParentDirs((File)this.outputFile);
        try (FileOutputStream output = new FileOutputStream(this.outputFile);){
            for (File sourceFile : sourceFiles) {
                FileInputStream input = new FileInputStream(sourceFile);
                Throwable throwable = null;
                try {
                    IOUtils.copy((InputStream)input, (OutputStream)output);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (input == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)input).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)input).close();
                }
            }
        }
    }

    void setSources(OrderableFileSet[] sources) {
        this.sources = sources;
    }

    void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    void setRepeatedFileStrategy(RepeatedFileStrategy repeatedFileStrategy) {
        this.repeatedFileStrategy = repeatedFileStrategy;
    }

    void setIgnoreEmptySourcesList(boolean ignoreEmptySourcesList) {
        this.ignoreEmptySourcesList = ignoreEmptySourcesList;
    }

    private static class SourceFileNotFoundException
    extends MojoExecutionException {
        public SourceFileNotFoundException(Object source, String shortMessage, String longMessage) {
            super(source, shortMessage, longMessage);
        }

        public SourceFileNotFoundException(String message, Exception cause) {
            super(message, cause);
        }

        public SourceFileNotFoundException(String message, Throwable cause) {
            super(message, cause);
        }

        public SourceFileNotFoundException(String message) {
            super(message);
        }
    }

    private static class BadSourceSpecificationException
    extends MojoExecutionException {
        public BadSourceSpecificationException(Object source, String shortMessage, String longMessage) {
            super(source, shortMessage, longMessage);
        }

        public BadSourceSpecificationException(String message, Exception cause) {
            super(message, cause);
        }

        public BadSourceSpecificationException(String message, Throwable cause) {
            super(message, cause);
        }

        public BadSourceSpecificationException(String message) {
            super(message);
        }
    }

    private static class NoRepeatsSet<E>
    extends LinkedHashSet<E> {
        private NoRepeatsSet() {
        }

        @Override
        public boolean add(E e) {
            boolean result = super.add(e);
            if (!result) {
                throw new RepeatedItemException("add() failed, indicating that element was already in set");
            }
            return true;
        }
    }

    static class RepeatedItemException
    extends IllegalArgumentException {
        public RepeatedItemException(String s) {
            super(s);
        }
    }

    public static enum RepeatedFileStrategy {
        repeat,
        ignore,
        fail;


        public Collection<File> createBucket() {
            switch (this) {
                case repeat: {
                    return new ArrayList<File>();
                }
                case ignore: {
                    return new LinkedHashSet<File>();
                }
                case fail: {
                    return new NoRepeatsSet<File>();
                }
            }
            throw new IllegalStateException("bug: strategy " + (Object)((Object)this) + " not handled");
        }
    }
}

