/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.catmvnplugin;

import com.github.mike10004.catmvnplugin.OrderableFileSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.codehaus.plexus.logging.Logger;

public class OrderableFileSetManager
extends FileSetManager {
    public OrderableFileSetManager(Log log, boolean verbose) {
        super(log, verbose);
    }

    public OrderableFileSetManager(Log log) {
        super(log);
    }

    public OrderableFileSetManager(Logger log, boolean verbose) {
        super(log, verbose);
    }

    public OrderableFileSetManager(Logger log) {
        super(log);
    }

    public OrderableFileSetManager() {
    }

    protected OrderableFileSet.OrderingStrategy getOrderingStrategy(FileSet fileSet) {
        if (fileSet instanceof OrderableFileSet) {
            OrderableFileSet.OrderingStrategy strategy = ((OrderableFileSet)fileSet).getOrderingStrategy();
            if (strategy == null) {
                throw new IllegalArgumentException("ordered file set must have strategy set");
            }
            return strategy;
        }
        return OrderableFileSet.OrderingStrategy.traditional;
    }

    public String[] getIncludedFiles(FileSet fileSet) {
        return this.getIncludedFilesOrDirectories(fileSet, x$0 -> super.getIncludedFiles(x$0));
    }

    protected String[] getIncludedFilesOrDirectories(FileSet fileSet, Function<FileSet, String[]> superGetter) {
        OrderableFileSet.OrderingStrategy strategy = this.getOrderingStrategy(fileSet);
        switch (strategy) {
            case traditional: {
                return superGetter.apply(fileSet);
            }
            case strict: {
                return this.getIncludedFilesOrDirectoriesInIncludesOrder(fileSet, superGetter);
            }
        }
        throw new IllegalArgumentException("bug: unhandled ordering strategy: " + (Object)((Object)strategy));
    }

    private static FileSet cloneExceptIncludes(FileSet source) {
        FileSet target = new FileSet();
        target.setDirectory(source.getDirectory());
        target.setLineEnding(source.getLineEnding());
        target.setModelEncoding(source.getModelEncoding());
        target.setDirectoryMode(source.getDirectoryMode());
        target.setExcludes(source.getExcludes());
        target.setFileMode(source.getFileMode());
        target.setFollowSymlinks(source.isFollowSymlinks());
        target.setMapper(source.getMapper());
        target.setOutputDirectory(source.getOutputDirectory());
        target.setUseDefaultExcludes(source.isUseDefaultExcludes());
        return target;
    }

    protected Stream<FileSet> expandIncludes(FileSet orderedFileSet) {
        List includes = orderedFileSet.getIncludes();
        return includes.stream().map(include -> {
            FileSet singleIncludeFileset = OrderableFileSetManager.cloneExceptIncludes(orderedFileSet);
            singleIncludeFileset.setIncludes(Collections.singletonList(include));
            return singleIncludeFileset;
        });
    }

    protected String[] getIncludedFilesOrDirectoriesInIncludesOrder(FileSet orderedFileSet, Function<FileSet, String[]> getter) {
        Stream<FileSet> virtualFilesets = this.expandIncludes(orderedFileSet);
        LinkedHashSet expandedList = new LinkedHashSet();
        virtualFilesets.forEach(fileset -> {
            String[] includedThings = (String[])getter.apply((FileSet)fileset);
            expandedList.addAll(Arrays.asList(includedThings));
        });
        return (String[])expandedList.stream().toArray(String[]::new);
    }

    public String[] getIncludedDirectories(FileSet fileSet) {
        return this.getIncludedFilesOrDirectories(fileSet, x$0 -> super.getIncludedDirectories(x$0));
    }
}

