/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.catmvnplugin;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.maven.shared.model.fileset.FileSet;

public class OrderableFileSet
extends FileSet {
    private OrderingStrategy orderingStrategy = OrderingStrategy.strict;
    @Nullable
    private SortingStrategy sort;
    private boolean ignoreEmptyIncludedFilesList;

    public OrderingStrategy getOrderingStrategy() {
        return this.orderingStrategy;
    }

    public void setOrderingStrategy(OrderingStrategy orderingStrategy) {
        this.orderingStrategy = Objects.requireNonNull(orderingStrategy);
    }

    public boolean isIgnoreEmptyIncludedFilesList() {
        return this.ignoreEmptyIncludedFilesList;
    }

    public void setIgnoreEmptyIncludedFilesList(boolean ignoreEmptyIncludedFilesList) {
        this.ignoreEmptyIncludedFilesList = ignoreEmptyIncludedFilesList;
    }

    @Nullable
    public SortingStrategy getSort() {
        return this.sort;
    }

    public void setSort(@Nullable SortingStrategy sort) {
        this.sort = sort;
    }

    public static enum SortingStrategy {
        none,
        alphabetical;


        public void sort(String[] items) {
            if (this != none) {
                Arrays.sort(items, this.getComparator());
            }
        }

        private Comparator<String> getComparator() {
            switch (this) {
                case alphabetical: {
                    return String::compareTo;
                }
            }
            throw new IllegalStateException("BUG: unhandled enum constant: SortingStrategy" + (Object)((Object)this));
        }
    }

    public static enum OrderingStrategy {
        traditional,
        strict;

    }
}

