/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.catmvnplugin;

import com.github.mike10004.catmvnplugin.OrderableFileSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.codehaus.plexus.logging.Logger;

public class OrderableFileSetManager
extends FileSetManager {
    public OrderableFileSetManager(Log log, boolean verbose) {
        super(log, verbose);
    }

    public OrderableFileSetManager(Log log) {
        super(log);
    }

    public OrderableFileSetManager(Logger log, boolean verbose) {
        super(log, verbose);
    }

    public OrderableFileSetManager(Logger log) {
        super(log);
    }

    public OrderableFileSetManager() {
    }

    @Nullable
    protected OrderableFileSet.SortingStrategy getSortingStrategy(FileSet fileSet) {
        return this.maybeGetProperty(fileSet, OrderableFileSet::getSort, null);
    }

    private <S, T> T maybeGetProperty(Object valueHolder, Function<S, T> valueGetter, T defaultValue) {
        try {
            Object orderableFileSet = valueHolder;
            return valueGetter.apply(orderableFileSet);
        }
        catch (ClassCastException ignore) {
            return defaultValue;
        }
    }

    protected OrderableFileSet.OrderingStrategy getOrderingStrategy(FileSet fileSet) {
        OrderableFileSet.OrderingStrategy strategy = this.maybeGetProperty(fileSet, OrderableFileSet::getOrderingStrategy, OrderableFileSet.OrderingStrategy.traditional);
        if (strategy == null) {
            throw new IllegalArgumentException("ordered file set must have strategy set");
        }
        return strategy;
    }

    public String[] getIncludedFiles(FileSet fileSet) {
        return this.getIncludedFilesOrDirectories(fileSet, x$0 -> super.getIncludedFiles(x$0));
    }

    protected String[] getIncludedFilesOrDirectories(FileSet fileSet, Function<FileSet, String[]> superGetter) {
        String[] includedFilesAndDirectories;
        OrderableFileSet.OrderingStrategy strategy = this.getOrderingStrategy(fileSet);
        switch (strategy) {
            case traditional: {
                includedFilesAndDirectories = superGetter.apply(fileSet);
                break;
            }
            case strict: {
                if (fileSet.getIncludes().isEmpty()) {
                    includedFilesAndDirectories = superGetter.apply(fileSet);
                    break;
                }
                includedFilesAndDirectories = this.getIncludedFilesOrDirectoriesInIncludesOrder(fileSet, superGetter);
                break;
            }
            default: {
                throw new IllegalArgumentException("bug: unhandled ordering strategy: " + (Object)((Object)strategy));
            }
        }
        OrderableFileSet.SortingStrategy sortingStrategy = this.getSortingStrategy(fileSet);
        if (sortingStrategy != null) {
            sortingStrategy.sort(includedFilesAndDirectories);
        }
        return includedFilesAndDirectories;
    }

    private static FileSet cloneExceptIncludes(FileSet source) {
        FileSet target = new FileSet();
        target.setDirectory(source.getDirectory());
        target.setLineEnding(source.getLineEnding());
        target.setModelEncoding(source.getModelEncoding());
        target.setDirectoryMode(source.getDirectoryMode());
        target.setExcludes(source.getExcludes());
        target.setFileMode(source.getFileMode());
        target.setFollowSymlinks(source.isFollowSymlinks());
        target.setMapper(source.getMapper());
        target.setOutputDirectory(source.getOutputDirectory());
        target.setUseDefaultExcludes(source.isUseDefaultExcludes());
        return target;
    }

    protected Stream<FileSet> expandIncludes(FileSet orderedFileSet) {
        List includes = orderedFileSet.getIncludes();
        return includes.stream().map(include -> {
            FileSet singleIncludeFileset = OrderableFileSetManager.cloneExceptIncludes(orderedFileSet);
            singleIncludeFileset.setIncludes(Collections.singletonList(include));
            return singleIncludeFileset;
        });
    }

    protected String[] getIncludedFilesOrDirectoriesInIncludesOrder(FileSet orderedFileSet, Function<FileSet, String[]> getter) {
        Stream<FileSet> virtualFilesets = this.expandIncludes(orderedFileSet);
        LinkedHashSet expandedList = new LinkedHashSet();
        virtualFilesets.forEach(fileset -> {
            String[] includedThings = (String[])getter.apply((FileSet)fileset);
            expandedList.addAll(Arrays.asList(includedThings));
        });
        return expandedList.toArray(new String[0]);
    }

    public String[] getIncludedDirectories(FileSet fileSet) {
        return this.getIncludedFilesOrDirectories(fileSet, x$0 -> super.getIncludedDirectories(x$0));
    }
}

