/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.slf4j.LoggerFactory;

public class Bys {
    private Bys() {
    }

    public static By conjoin(By first, By second, By ... others) {
        List conditions = Lists.asList((Object)first, (Object)second, (Object[])others);
        return Bys.conjoin(conditions);
    }

    public static By conjoin(Iterable<? extends By> bys) {
        ImmutableList conditions = ImmutableList.copyOf(bys);
        Preconditions.checkArgument((!conditions.isEmpty() ? 1 : 0) != 0, (Object)"set of conditions must be nonempty");
        return new By((List)conditions){
            final /* synthetic */ List val$conditions;
            {
                this.val$conditions = list;
            }

            public List<WebElement> findElements(SearchContext context) {
                ArrayList<ImmutableSet> sets = new ArrayList<ImmutableSet>(this.val$conditions.size());
                for (By condition : this.val$conditions) {
                    List elements = condition.findElements(context);
                    sets.add(ImmutableSet.copyOf((Collection)elements));
                }
                Iterator results = sets.iterator();
                Set intersection = null;
                while (results.hasNext()) {
                    Set now = (Set)results.next();
                    if (intersection == null) {
                        intersection = now;
                        continue;
                    }
                    intersection = Sets.intersection((Set)intersection, (Set)now);
                }
                Preconditions.checkState((intersection != null ? 1 : 0) != 0, (Object)"bug");
                return ImmutableList.copyOf(intersection);
            }
        };
    }

    public static By attribute(By preFilter, String attributeName, Predicate<? super String> predicate) {
        return Bys.predicate(preFilter, Predicates.attribute(attributeName, predicate));
    }

    public static By predicate(final By preFilter, final Predicate<? super WebElement> elementPredicate) {
        return new By(){

            public List<WebElement> findElements(SearchContext context) {
                List possibles = preFilter.findElements(context);
                ArrayList<WebElement> confirmeds = null;
                for (WebElement element : possibles) {
                    boolean applicable = elementPredicate.apply((Object)element);
                    if (!applicable) continue;
                    if (confirmeds == null) {
                        confirmeds = new ArrayList<WebElement>(Math.min(possibles.size(), 10));
                    }
                    confirmeds.add(element);
                }
                return confirmeds == null ? ImmutableList.of() : confirmeds;
            }
        };
    }

    public static By elementWithTextFuzzy(By preFilter, String fuzzilyRequiredText) {
        return Bys.elementWithText(preFilter, Predicates.textEqualsFuzzy(fuzzilyRequiredText));
    }

    public static By elementWithTextIgnoreCase(By preFilter, String requiredText) {
        return Bys.elementWithText(preFilter, Predicates.textEqualsIgnoreCase(requiredText));
    }

    public static By elementWithText(By preFilter, String requiredText) {
        return Bys.elementWithText(preFilter, (Predicate<String>)com.google.common.base.Predicates.equalTo((Object)requiredText));
    }

    public static By elementWithText(By preFilter, Predicate<String> textPredicate) {
        return Bys.predicate(preFilter, Predicates.compose(textPredicate, Transforms.elementToText()));
    }

    public static class Predicates {
        private Predicates() {
        }

        public static Predicate<WebElement> attribute(final String attributeName, final Predicate<? super String> valuePredicate) {
            Preconditions.checkNotNull((Object)attributeName, (Object)"attributename");
            Preconditions.checkNotNull(valuePredicate, (Object)"valuePredicate");
            return new Predicate<WebElement>(){

                public boolean apply(@Nullable WebElement input) {
                    if (input == null) {
                        return false;
                    }
                    String attributeValue = input.getAttribute(attributeName);
                    return attributeValue != null && valuePredicate.apply((Object)attributeValue);
                }
            };
        }

        public static Predicate<String> textEqualsIgnoreCase(final String caseInsensitiveText) {
            Preconditions.checkNotNull((Object)caseInsensitiveText);
            return new Predicate<String>(){

                public boolean apply(@Nullable String input) {
                    return input != null && caseInsensitiveText.equalsIgnoreCase(input);
                }
            };
        }

        public static Predicate<String> textEqualsFuzzy(String fuzzilyRequiredText) {
            return Predicates.compose(com.google.common.base.Predicates.equalTo((Object)fuzzilyRequiredText), Transforms.fuzzy());
        }

        public static Predicate<String> textWithMaxLevenshteinDistanceFrom(final String reference, final int max) {
            Preconditions.checkNotNull((Object)reference, (Object)"reference");
            return new Predicate<String>(){

                public boolean apply(@Nullable String input) {
                    return input != null && StringUtils.getLevenshteinDistance((CharSequence)reference, (CharSequence)input) <= max;
                }
            };
        }

        public static <A, B> Predicate<A> compose(Predicate<B> predicate, Function<A, ? extends B> function) {
            return com.google.common.base.Predicates.compose(predicate, function);
        }

        public static Predicate<String> valueIsUriWithPath(String requiredPath) {
            return Predicates.valueIsUriWithPath((Predicate<String>)com.google.common.base.Predicates.equalTo((Object)requiredPath));
        }

        public static Predicate<String> valueIsUriWithPath(final Predicate<String> pathRequirement) {
            Preconditions.checkNotNull(pathRequirement, (Object)"pathRequirement");
            return new Predicate<String>(){

                public boolean apply(String input) {
                    if (input != null) {
                        URI uri;
                        try {
                            uri = new URI(input);
                        }
                        catch (URISyntaxException e) {
                            LoggerFactory.getLogger(Predicates.class).debug("href attribute value is not a valid URI {}", (Object)StringUtils.abbreviate((String)input, (int)256));
                            return false;
                        }
                        String path = uri.getPath();
                        return pathRequirement.apply((Object)path);
                    }
                    return false;
                }
            };
        }
    }

    public static class Transforms {
        private static final Function<WebElement, String> elementToText = new Function<WebElement, String>(){

            public String apply(WebElement input) {
                return input.getText();
            }
        };
        private static final Function<String, String> fuzzy = new Function<String, String>(){
            private final CharMatcher retained = CharMatcher.javaLetter();

            public String apply(String input) {
                Preconditions.checkNotNull((Object)input, (Object)"input");
                return this.retained.retainFrom((CharSequence)input).toLowerCase();
            }
        };

        private Transforms() {
        }

        public static Function<WebElement, String> elementToText() {
            return elementToText;
        }

        public static Function<WebElement, String> elementToAttributeValue(final String attributeName) {
            return new Function<WebElement, String>(){

                @Nullable
                public String apply(WebElement input) {
                    return input.getAttribute(attributeName);
                }
            };
        }

        public static Function<String, String> fuzzy() {
            return fuzzy;
        }
    }
}

