/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.github.mike10004.chromecookieimplant.ChromeCookieImplanter;
import com.github.mike10004.seleniumhelp.ChromeCookieTransform;
import com.github.mike10004.seleniumhelp.ChromeWebDriverFactory;
import com.github.mike10004.seleniumhelp.DeserializableCookie;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChromeCookiePreparer
implements ChromeWebDriverFactory.CookiePreparer {
    private static final Logger log = LoggerFactory.getLogger(ChromeCookiePreparer.class);
    private final Path scratchDir;
    private final Supplier<? extends Collection<DeserializableCookie>> cookiesSupplier;
    private final transient ChromeCookieTransform chromeCookieTransform = new ChromeCookieTransform();
    private final ChromeCookieImplanter implanterClient;

    public ChromeCookiePreparer(Path scratchDir, Supplier<? extends Collection<DeserializableCookie>> cookiesSupplier) {
        this.scratchDir = (Path)Preconditions.checkNotNull((Object)scratchDir);
        this.cookiesSupplier = (Supplier)Preconditions.checkNotNull(cookiesSupplier);
        this.implanterClient = new ChromeCookieImplanter();
    }

    @Override
    public void supplementOptions(ChromeOptions options) throws IOException {
        File crxFile = File.createTempFile("chrome-cookie-implant", ".crx", this.scratchDir.toFile());
        try (FileOutputStream crxOut = new FileOutputStream(crxFile);){
            this.implanterClient.copyCrxTo((OutputStream)crxOut);
        }
        options.addExtensions(new File[]{crxFile});
    }

    @Override
    public void prepareCookies(ChromeDriver driver) throws WebDriverException {
        Stream<DeserializableCookie> inputCookies = this.cookiesSupplier.get().stream();
        List chromeCookies = inputCookies.map(this.chromeCookieTransform::transform).collect(Collectors.toList());
        this.implanterClient.implant(chromeCookies, driver);
        log.debug("{} cookies imported using implant extension", (Object)chromeCookies.size());
        driver.get("data:,");
    }
}

