/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.github.mike10004.chromecookieimplant.ChromeCookie;
import com.github.mike10004.seleniumhelp.DeserializableCookie;
import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import org.slf4j.LoggerFactory;

class ChromeCookieTransform {
    private static CharMatcher dotMatcher = CharMatcher.is((char)'.');
    private static CharMatcher slashMatcher = CharMatcher.is((char)'/');

    ChromeCookieTransform() {
    }

    public ChromeCookie transform(DeserializableCookie input) {
        String url = this.fabricateUrlFromDomain(input.getBestDomainProperty(), input.isSecure(), input.getPath());
        ChromeCookie output = ChromeCookie.builder((String)url).name(input.getName()).value(input.getValue()).domain(input.getBestDomainProperty()).path(input.getPath()).expirationDate(input.getExpiryDate()).secure(Boolean.valueOf(input.isSecure())).httpOnly(Boolean.valueOf(input.isHttpOnly())).sameSite(ChromeCookie.SameSiteStatus.no_restriction).build();
        return output;
    }

    protected String fabricateUrlFromDomain(String domain, boolean secure, String path) {
        if (Strings.isNullOrEmpty((String)domain)) {
            LoggerFactory.getLogger(ChromeCookieTransform.class).warn("input cookie has no domain, so no URL can be fabricated; chrome will not like this");
            return "";
        }
        domain = dotMatcher.trimLeadingFrom((CharSequence)domain);
        String scheme = secure ? "https" : "http";
        path = slashMatcher.trimLeadingFrom((CharSequence)Strings.nullToEmpty((String)path));
        return scheme + "://" + domain + "/" + path;
    }
}

