/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.github.mike10004.seleniumhelp.ChromeCookiePreparer;
import com.github.mike10004.seleniumhelp.DeserializableCookie;
import com.github.mike10004.seleniumhelp.EnvironmentWebDriverFactory;
import com.github.mike10004.xvfbselenium.WebDriverSupport;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.lightbody.bmp.BrowserMobProxy;
import net.lightbody.bmp.client.ClientUtil;
import net.lightbody.bmp.mitm.CertificateAndKeySource;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public class ChromeWebDriverFactory
extends EnvironmentWebDriverFactory {
    private final ChromeOptions chromeOptions;
    private final Capabilities capabilitiesOverrides;
    private final CookiePreparer cookiePreparer;
    private static final CookiePreparer cookielessPreparer = new CookiePreparer(){

        @Override
        public void supplementOptions(ChromeOptions options) {
        }

        @Override
        public void prepareCookies(ChromeDriver driver) {
        }
    };

    public ChromeWebDriverFactory() {
        this(ChromeWebDriverFactory.builder());
    }

    protected ChromeWebDriverFactory(Builder builder) {
        super(builder);
        this.chromeOptions = builder.chromeOptions;
        this.capabilitiesOverrides = builder.capabilitiesOverrides;
        this.cookiePreparer = builder.cookiePreparer;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public WebDriver createWebDriver(BrowserMobProxy proxy, @Nullable CertificateAndKeySource certificateAndKeySource) throws IOException {
        this.cookiePreparer.supplementOptions(this.chromeOptions);
        DesiredCapabilities capabilities = this.toCapabilities(this.chromeOptions);
        Proxy seleniumProxy = ClientUtil.createSeleniumProxy((BrowserMobProxy)proxy);
        capabilities.setCapability("proxy", (Object)seleniumProxy);
        capabilities.merge(this.capabilitiesOverrides);
        ChromeDriver driver = WebDriverSupport.chromeInEnvironment((Map)((Map)this.environmentSupplier.get())).create((Capabilities)capabilities);
        this.cookiePreparer.prepareCookies(driver);
        return driver;
    }

    protected DesiredCapabilities toCapabilities(ChromeOptions chromeOptions) {
        DesiredCapabilities capabilities = DesiredCapabilities.chrome();
        capabilities.setCapability("chromeOptions", (Object)chromeOptions);
        return capabilities;
    }

    public static CookiePreparer makeCookieImplanter(Path scratchDir, Supplier<? extends Collection<DeserializableCookie>> cookiesSupplier) {
        return new ChromeCookiePreparer(scratchDir, cookiesSupplier);
    }

    static /* synthetic */ CookiePreparer access$400() {
        return cookielessPreparer;
    }

    public static final class Builder
    extends EnvironmentWebDriverFactory.Builder<Builder> {
        private CookiePreparer cookiePreparer = ChromeWebDriverFactory.access$400();
        private Capabilities capabilitiesOverrides = new DesiredCapabilities();
        private ChromeOptions chromeOptions = new ChromeOptions();

        private Builder() {
        }

        public Builder chromeOptions(ChromeOptions val) {
            this.chromeOptions = val;
            return this;
        }

        public Builder capabilitiesOverrides(Capabilities val) {
            this.capabilitiesOverrides = val;
            return this;
        }

        public Builder cookiePreparer(CookiePreparer val) {
            this.cookiePreparer = val;
            return this;
        }

        public ChromeWebDriverFactory build() {
            return new ChromeWebDriverFactory(this);
        }
    }

    public static interface CookiePreparer {
        public void supplementOptions(ChromeOptions var1) throws IOException;

        public void prepareCookies(ChromeDriver var1) throws WebDriverException;
    }
}

