/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.github.mike10004.seleniumhelp.DeserializableCookie;
import com.github.mike10004.seleniumhelp.FlexibleCookieSpec;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.math.LongMath;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import net.lightbody.bmp.core.har.HarEntry;
import net.lightbody.bmp.core.har.HarNameValuePair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.http.cookie.MalformedCookieException;

public class CookieCollection {
    private final ImmutableMultimap<HarEntry, DeserializableCookie> cookiesByEntry;

    @VisibleForTesting
    CookieCollection(Multimap<HarEntry, DeserializableCookie> cookiesByEntry) {
        this.cookiesByEntry = ImmutableMultimap.copyOf(cookiesByEntry);
    }

    @VisibleForTesting
    static long getEntryResponseInstant(HarEntry entry) {
        return LongMath.checkedAdd((long)entry.getStartedDateTime().getTime(), (long)entry.getTime());
    }

    public static CookieCollection build(Stream<HarEntry> headerValues) {
        return CookieCollection.build(headerValues, FlexibleCookieSpec.getDefault());
    }

    static CookieCollection build(Stream<HarEntry> headerValues, FlexibleCookieSpec cookieSpec) {
        ImmutableMultimap.Builder m = ImmutableMultimap.builder();
        headerValues.forEach(entry -> {
            List<DeserializableCookie> cookies = CookieCollection.makeCookiesFromEntry(cookieSpec, entry);
            m.putAll(entry, cookies);
        });
        return new CookieCollection((Multimap<HarEntry, DeserializableCookie>)m.build());
    }

    public ImmutableList<DeserializableCookie> makeUltimateCookieList() {
        return ImmutableList.copyOf(this.buildUltimateCookieMap().values());
    }

    @VisibleForTesting
    static Stream<HarEntry> sortHarEntriesByResponseInstant(Stream<HarEntry> entries) {
        return entries.sorted((Comparator<HarEntry>)Ordering.natural().onResultOf(CookieCollection::getEntryResponseInstant));
    }

    @VisibleForTesting
    Map<Triple<String, String, String>, DeserializableCookie> buildUltimateCookieMap() {
        TreeMap<Triple<String, String, String>, DeserializableCookie> updatingMap = new TreeMap<Triple<String, String, String>, DeserializableCookie>((Comparator<Triple<String, String, String>>)Ordering.natural());
        Stream<HarEntry> entriesByResponseInstant = CookieCollection.sortHarEntriesByResponseInstant(this.cookiesByEntry.keySet().stream());
        entriesByResponseInstant.forEach(harEntry -> {
            for (DeserializableCookie cookie : this.cookiesByEntry.get(harEntry)) {
                Triple cookieLabel = Triple.of((Object)MoreObjects.firstNonNull((Object)cookie.getBestDomainProperty(), (Object)""), (Object)MoreObjects.firstNonNull((Object)cookie.getName(), (Object)""), (Object)MoreObjects.firstNonNull((Object)cookie.getPath(), (Object)"/"));
                updatingMap.put(cookieLabel, cookie);
            }
        });
        return updatingMap;
    }

    private static List<DeserializableCookie> makeCookiesFromEntry(FlexibleCookieSpec cookieSpec, HarEntry entry) {
        URL originUrl;
        Date requestDate = entry.getStartedDateTime();
        try {
            originUrl = new URL(entry.getRequest().getUrl());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        Stream<String> headerValues = entry.getResponse().getHeaders().stream().filter(header -> "Set-Cookie".equalsIgnoreCase(header.getName())).map(HarNameValuePair::getValue);
        ArrayList<DeserializableCookie> cookies = new ArrayList<DeserializableCookie>();
        headerValues.forEach(headerValue -> {
            try {
                Stream<DeserializableCookie> cookieStream = cookieSpec.parse((String)headerValue, originUrl, requestDate).stream().map(x -> (DeserializableCookie)x);
                cookieStream.forEach(cookies::add);
            }
            catch (MalformedCookieException e) {
                throw new IllegalArgumentException(e);
            }
        });
        return cookies;
    }
}

