/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.github.mike10004.seleniumhelp.CookieUtility;
import com.github.mike10004.seleniumhelp.FlexibleCookieSpec;
import com.github.mike10004.seleniumhelp.SeleniumCookieConverter;
import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.Date;
import java.util.function.Predicate;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.impl.cookie.DefaultCookieSpecProvider;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class CookieFilter {
    private final CookieUtility cookieUtility = CookieUtility.getInstance();
    private final CookieSpec cookieSpec;

    public CookieFilter() {
        this(CookieFilter.createDefaultCookieSpec());
    }

    protected static CookieSpec createDefaultCookieSpec() {
        return new FlexibleCookieSpec(new DefaultCookieSpecProvider().create((HttpContext)new BasicHttpContext()));
    }

    public CookieFilter(CookieSpec cookieSpec) {
        this.cookieSpec = cookieSpec;
    }

    public Predicate<org.openqa.selenium.Cookie> makeSeleniumPredicate(URL url, Date date) {
        final Predicate<Cookie> apachePredicate = this.makeApachePredicate(url, date);
        return new Predicate<org.openqa.selenium.Cookie>(){
            private final SeleniumCookieConverter converter = new SeleniumCookieConverter();

            @Override
            public boolean test(org.openqa.selenium.Cookie cookie) {
                return apachePredicate.test(this.converter.convert(cookie));
            }
        };
    }

    public Predicate<Cookie> makeApachePredicate(URL url, Date date) {
        CookieUtility.ParsedCookieOrigin cookieOriginAndNormalizedUrl = this.cookieUtility.buildCookieOrigin(url);
        URL normalizedUrl = (URL)cookieOriginAndNormalizedUrl.getRight();
        String host = normalizedUrl.getHost();
        if (host.isEmpty()) {
            return cookie -> false;
        }
        CookieOrigin cookieOrigin = (CookieOrigin)cookieOriginAndNormalizedUrl.getLeft();
        Predicate<Cookie> notExpired = this.cookieUtility.notExpiredOn(date);
        Predicate<Cookie> matchesOrigin = this.originMatcher(cookieOrigin);
        Predicate<Cookie> notExpiredAndMatchesOrigin = notExpired.and(matchesOrigin);
        return notExpiredAndMatchesOrigin;
    }

    private Predicate<Cookie> originMatcher(CookieOrigin cookieOrigin) {
        return input -> {
            Preconditions.checkNotNull((Object)input, (Object)"input");
            boolean matches = this.cookieSpec.match(input, cookieOrigin);
            return matches;
        };
    }
}

