/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.github.mike10004.seleniumhelp.DeserializableCookie;
import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.http.Header;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.message.BasicHeader;

public class CookieUtility {
    private static final CookieUtility instance = new CookieUtility();
    private static final String LOCAL_FILESYSTEM_DOMAIN = "LOCAL_FILESYSTEM";
    private static CharMatcher legalNameChars = CharMatcher.noneOf((CharSequence)"=");
    private static CharMatcher legalOtherChars = CharMatcher.noneOf((CharSequence)";");
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss zzz");

    private CookieUtility() {
    }

    public static CookieUtility getInstance() {
        return instance;
    }

    public static CookieHash getIdentifier(Cookie apacheCookie) {
        return new CookieHash((String)Preconditions.checkNotNull((Object)apacheCookie.getDomain(), (Object)"domain"), (String)Preconditions.checkNotNull((Object)apacheCookie.getName(), (Object)"name"), (String)MoreObjects.firstNonNull((Object)apacheCookie.getPath(), (Object)"/"));
    }

    public static Function<String, Stream<Cookie>> headerToCookiesFunction(CookieOrigin cookieOrigin, CookieSpec cookieSpec) {
        return input -> {
            BasicHeader header = new BasicHeader("Set-Cookie", input);
            try {
                return cookieSpec.parse((Header)header, cookieOrigin).stream();
            }
            catch (MalformedCookieException e) {
                throw new IllegalArgumentException(e);
            }
        };
    }

    public ParsedCookieOrigin buildCookieOrigin(URL url) {
        URL normalizedUrl = this.replaceForCookieIfNecessary(url);
        CookieOrigin origin = new CookieOrigin(normalizedUrl.getHost(), this.getPort(normalizedUrl), normalizedUrl.getPath(), "https".equals(normalizedUrl.getProtocol()));
        return new ParsedCookieOrigin(origin, normalizedUrl);
    }

    public synchronized Predicate<Cookie> notExpiredOn(Date referenceDate) {
        Preconditions.checkNotNull((Object)referenceDate, (Object)"date");
        return cookie -> {
            Preconditions.checkNotNull((Object)cookie, (Object)"cookie");
            Date expiry = cookie.getExpiryDate();
            if (expiry == null) {
                return true;
            }
            boolean stillValid = expiry.after(referenceDate);
            return stillValid;
        };
    }

    protected int getPort(URL url) {
        if (url.getPort() != -1) {
            return url.getPort();
        }
        return url.getDefaultPort();
    }

    private URL replaceForCookieIfNecessary(URL url) {
        String protocol = url.getProtocol();
        boolean file = "file".equals(protocol);
        if (file) {
            try {
                url = CookieUtility.getUrlWithNewHostAndPort(url, LOCAL_FILESYSTEM_DOMAIN, 0);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return url;
    }

    private static URL getUrlWithNewHostAndPort(URL u, String newHost, int newPort) throws MalformedURLException {
        return CookieUtility.createNewUrl(u.getProtocol(), u.getUserInfo(), newHost, newPort, u.getPath(), u.getRef(), u.getQuery());
    }

    private static URL createNewUrl(String protocol, String userInfo, String host, int port, String path, String ref, String query) throws MalformedURLException {
        StringBuilder s = new StringBuilder();
        s.append(protocol);
        s.append("://");
        if (userInfo != null) {
            s.append(userInfo).append("@");
        }
        s.append(host);
        if (port != -1) {
            s.append(":").append(port);
        }
        if (path != null && !path.isEmpty()) {
            if ('/' != path.charAt(0)) {
                s.append("/");
            }
            s.append(path);
        }
        if (query != null) {
            s.append("?").append(query);
        }
        if (ref != null) {
            if (ref.isEmpty() || ref.charAt(0) != '#') {
                s.append("#");
            }
            s.append(ref);
        }
        URL url = new URL(s.toString());
        return url;
    }

    private static String checkOnlyContains(String value, CharMatcher permitted) {
        if (!permitted.matchesAllOf((CharSequence)value)) {
            throw new IllegalArgumentException(String.format("value \"%s\" does not match %s", StringEscapeUtils.escapeJava((String)value), permitted));
        }
        return value;
    }

    protected static String formatDateForHeader(Date date) {
        Preconditions.checkNotNull((Object)date, (Object)"date");
        return dateFormat.format(date);
    }

    @Nullable
    protected static String getDomain(Cookie c) {
        ClientCookie d;
        String dAttr;
        if (c instanceof ClientCookie && (dAttr = (d = (ClientCookie)c).getAttribute("domain")) != null) {
            return dAttr;
        }
        return c.getDomain();
    }

    public String formatSetCookieHeader(DeserializableCookie c) {
        String domain;
        StringBuilder b = new StringBuilder(512);
        b.append(CookieUtility.checkOnlyContains(c.getName(), legalNameChars));
        b.append('=');
        b.append(CookieUtility.checkOnlyContains(c.getValue(), legalOtherChars));
        if (c.getExpiryDate() != null) {
            b.append("; Expires=").append(CookieUtility.formatDateForHeader(c.getExpiryDate()));
        }
        if ((domain = CookieUtility.getDomain((Cookie)c)) != null) {
            b.append("; Domain=").append(domain);
        }
        if (c.getPath() != null) {
            b.append("; Path=").append(c.getPath());
        }
        if (c.isSecure()) {
            b.append("; Secure");
        }
        if (c.isHttpOnly()) {
            b.append("; HttpOnly");
        }
        return b.toString();
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public static class ParsedCookieOrigin
    extends Pair<CookieOrigin, URL> {
        public final CookieOrigin origin;
        public final URL normalizedUrl;
        private final ImmutablePair<CookieOrigin, URL> delegate;

        public ParsedCookieOrigin(CookieOrigin origin, URL normalizedUrl) {
            this.origin = (CookieOrigin)Preconditions.checkNotNull((Object)origin);
            this.normalizedUrl = (URL)Preconditions.checkNotNull((Object)normalizedUrl);
            this.delegate = ImmutablePair.of((Object)origin, (Object)normalizedUrl);
        }

        public CookieOrigin getLeft() {
            return (CookieOrigin)this.delegate.getLeft();
        }

        public URL getRight() {
            return (URL)this.delegate.getRight();
        }

        public URL setValue(URL value) {
            return (URL)this.delegate.setValue((Object)value);
        }

        public URL getValue() {
            return (URL)this.delegate.getValue();
        }

        public int compareTo(Pair<CookieOrigin, URL> other) {
            return this.delegate.compareTo(other);
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    public static class CookieHash
    extends Triple<String, String, String> {
        private final ImmutableTriple<String, String, String> inner;

        public CookieHash(String domain, String name, String path) {
            this((ImmutableTriple<String, String, String>)ImmutableTriple.of((Object)domain, (Object)name, (Object)path));
        }

        private CookieHash(ImmutableTriple<String, String, String> inner) {
            this.inner = inner;
        }

        public String getLeft() {
            return (String)this.inner.getLeft();
        }

        public String getMiddle() {
            return (String)this.inner.getMiddle();
        }

        public String getRight() {
            return (String)this.inner.getRight();
        }

        public int compareTo(Triple<String, String, String> other) {
            return this.inner.compareTo(other);
        }

        public boolean equals(Object obj) {
            return this.inner.equals(obj);
        }

        public int hashCode() {
            return this.inner.hashCode();
        }

        public String toString() {
            return this.inner.toString();
        }
    }
}

