/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.opencsv.CSVReader;
import com.opencsv.CSVWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

class Csvs {
    private static final HeaderStrategy headersFromFirstRowStrategy = new HeaderStrategy(){

        @Override
        public String[] produceHeaders(CSVReader readerBeforeFirstRead) throws IOException {
            return readerBeforeFirstRead.readNext();
        }
    };

    private Csvs() {
    }

    public static HeaderStrategy headersFromFirstRow() {
        return headersFromFirstRowStrategy;
    }

    public static HeaderStrategy staticHeaders(final Iterable<String> headers) {
        Preconditions.checkNotNull(headers);
        return new HeaderStrategy(){

            @Override
            public String[] produceHeaders(CSVReader readerBeforeFirstRead) throws IOException {
                return (String[])Iterables.toArray((Iterable)headers, String.class);
            }
        };
    }

    public static List<Map<String, String>> readRowMaps(CharSource source, HeaderStrategy headerStrategy) throws IOException {
        String[] headers = null;
        ArrayList<Map<String, String>> rows = new ArrayList<Map<String, String>>();
        try (CSVReader reader = new CSVReader(source.openStream());){
            while (true) {
                if (headers == null) {
                    headers = headerStrategy.produceHeaders(reader);
                    if (headers != null) continue;
                    break;
                }
                String[] row = reader.readNext();
                if (row == null) {
                    break;
                }
                Preconditions.checkState((row.length == headers.length ? 1 : 0) != 0, (String)"incongruent row length %d (%d headers)", (int)row.length, (int)headers.length);
                LinkedHashMap<String, String> rowMap = new LinkedHashMap<String, String>(row.length);
                for (int i = 0; i < row.length; ++i) {
                    rowMap.put(headers[i], row[i]);
                }
                rows.add(rowMap);
            }
        }
        return rows;
    }

    public static String[] makeRowFromMap(List<String> headers, Map<String, String> map, String defaultValue, UnknownKeyStrategy unknownKeyStrategy) {
        Preconditions.checkNotNull((Object)((Object)unknownKeyStrategy), (Object)"unknownKeyStrategy");
        Object[] row = new String[headers.size()];
        Arrays.fill(row, defaultValue);
        for (String key : map.keySet()) {
            int index = headers.indexOf(key);
            if (index >= 0) {
                String value = map.get(key);
                String valueStr = value == null ? null : value.toString();
                if (valueStr == null) continue;
                row[index] = valueStr;
                continue;
            }
            if (unknownKeyStrategy == UnknownKeyStrategy.FAIL) {
                throw new UnknownKeyException(key);
            }
            if (unknownKeyStrategy == UnknownKeyStrategy.IGNORE) continue;
            throw new IllegalStateException("bug: unhandled enum constant " + (Object)((Object)unknownKeyStrategy));
        }
        return row;
    }

    public static int writeRowMapsWithHeaders(Iterable<String> headers, Iterable<Map<String, String>> rows, String defaultValue, UnknownKeyStrategy unknownKeyStrategy, CharSink sink) throws IOException {
        return Csvs.writeRowMaps(headers, true, rows, defaultValue, unknownKeyStrategy, sink);
    }

    public static int writeRowMaps(Iterable<String> headers, Iterable<Map<String, String>> rows, String defaultValue, UnknownKeyStrategy unknownKeyStrategy, CharSink sink) throws IOException {
        return Csvs.writeRowMaps(headers, false, rows, defaultValue, unknownKeyStrategy, sink);
    }

    private static int writeRowMaps(Iterable<String> headers, boolean includeHeaders, Iterable<Map<String, String>> rows, String defaultValue, UnknownKeyStrategy unknownKeyStrategy, CharSink sink) throws IOException {
        ImmutableList headersList = ImmutableList.copyOf(headers);
        int numOutputRows = 0;
        try (CSVWriter out = new CSVWriter(sink.openStream());){
            if (includeHeaders) {
                out.writeNext((String[])Iterables.toArray(headers, String.class));
            }
            ++numOutputRows;
            for (Map<String, String> rowInput : rows) {
                String[] rowOutput = Csvs.makeRowFromMap((List<String>)headersList, rowInput, defaultValue, unknownKeyStrategy);
                out.writeNext(rowOutput);
                ++numOutputRows;
            }
        }
        return numOutputRows;
    }

    public static String writeRowMapsWithHeadersToString(Iterable<String> headers, Iterable<Map<String, String>> rows, String defaultValue, UnknownKeyStrategy unknownKeyStrategy) throws IOException {
        return Csvs.writeRowMapsToString(headers, true, rows, defaultValue, unknownKeyStrategy);
    }

    public static String writeRowMapsToString(Iterable<String> headers, Iterable<Map<String, String>> rows, String defaultValue, UnknownKeyStrategy unknownKeyStrategy) throws IOException {
        return Csvs.writeRowMapsToString(headers, false, rows, defaultValue, unknownKeyStrategy);
    }

    private static String writeRowMapsToString(Iterable<String> headers, boolean includeHeaders, Iterable<Map<String, String>> rows, String defaultValue, UnknownKeyStrategy unknownKeyStrategy) throws IOException {
        CharBucket bucket = new CharBucket(256);
        Csvs.writeRowMaps(headers, includeHeaders, rows, defaultValue, unknownKeyStrategy, bucket);
        return bucket.toString();
    }

    public Converter<String[], Map<String, String>> rowToMapConverter(Iterable<String> columnNames) {
        return this.rowToMapConverter(columnNames, UnknownKeyStrategy.IGNORE, "");
    }

    public Converter<String[], Map<String, String>> rowToMapConverter(Iterable<String> columnNames, UnknownKeyStrategy unknownKeyStrategy, @Nullable String defaultColumnValue) {
        return new RowToMapConverter(columnNames, unknownKeyStrategy, defaultColumnValue);
    }

    static class RowToMapConverter
    extends Converter<String[], Map<String, String>> {
        private final ImmutableList<String> columnNames;
        private final String defaultColumnValue;
        private final UnknownKeyStrategy unknownKeyStrategy;

        public RowToMapConverter(Iterable<String> columnNames, UnknownKeyStrategy unknownKeyStrategy, @Nullable String defaultColumnValue) {
            this.columnNames = ImmutableList.copyOf(columnNames);
            this.unknownKeyStrategy = (UnknownKeyStrategy)((Object)Preconditions.checkNotNull((Object)((Object)unknownKeyStrategy)));
            this.defaultColumnValue = defaultColumnValue;
        }

        protected ImmutableMap<String, String> doForward(String[] row) {
            Preconditions.checkArgument((row.length == this.columnNames.size() ? 1 : 0) != 0, (String)"row incongruent with known headers: %d != %d (%s)", (Object)row.length, (Object)this.columnNames.size(), this.columnNames);
            ImmutableMap.Builder map = ImmutableMap.builder();
            for (int i = 0; i < row.length; ++i) {
                map.put(this.columnNames.get(i), (Object)row[i]);
            }
            return map.build();
        }

        protected String[] doBackward(Map<String, String> map) {
            return Csvs.makeRowFromMap(this.columnNames, map, this.defaultColumnValue, this.unknownKeyStrategy);
        }
    }

    private static class CharBucket
    extends CharSink {
        private final StringWriter sw;

        public CharBucket(int initialSize) {
            this(new StringWriter(initialSize));
        }

        public CharBucket(StringWriter sw) {
            this.sw = (StringWriter)Preconditions.checkNotNull((Object)sw);
        }

        public Writer openStream() throws IOException {
            return this.sw;
        }

        public String toString() {
            return this.sw.toString();
        }
    }

    static class UnknownKeyException
    extends IllegalArgumentException {
        public UnknownKeyException(String key) {
            super(StringUtils.abbreviate((String)key, (int)128));
        }
    }

    public static enum UnknownKeyStrategy {
        IGNORE,
        FAIL;

    }

    public static interface HeaderStrategy {
        @Nullable
        public String[] produceHeaders(CSVReader var1) throws IOException;
    }
}

