/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.github.mike10004.nativehelper.Program;
import com.github.mike10004.nativehelper.ProgramWithOutputStrings;
import com.github.mike10004.nativehelper.ProgramWithOutputStringsResult;
import com.github.mike10004.nativehelper.Whicher;
import com.github.mike10004.seleniumhelp.Csvs;
import com.github.mike10004.seleniumhelp.DeserializableCookie;
import com.github.mike10004.seleniumhelp.ExplodedCookieConverter;
import com.github.mike10004.seleniumhelp.FirefoxCookieRowTransform;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Converter;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.CharSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FirefoxCookieDb {
    static final ImmutableList<String> sqliteColumnNames = ImmutableList.of((Object)"id", (Object)"baseDomain", (Object)"originAttributes", (Object)"name", (Object)"value", (Object)"host", (Object)"path", (Object)"expiry", (Object)"lastAccessed", (Object)"creationTime", (Object)"isSecure", (Object)"isHttpOnly", (Object[])new String[]{"appId", "inBrowserElement"});
    private static final String TABLE_NAME = "moz_cookies";
    private static final Logger log = LoggerFactory.getLogger(FirefoxCookieDb.class);
    private static final String DEFAULT_SQLITE_CELL_VALUE = "";

    private FirefoxCookieDb() {
    }

    public static Importer getImporter() {
        return new Sqlite3ProgramImporter();
    }

    public static Exporter getExporter() {
        return new Sqlite3ProgramExporter();
    }

    protected static boolean isSqlite3PresentOnSystemPath() {
        return Whicher.gnu().which("sqlite3").isPresent();
    }

    @VisibleForTesting
    static class Sqlite3ProgramImporter
    implements Importer {
        private static final ImmutableList<String> CREATE_TABLE_SQL = ImmutableList.of((Object)"CREATE TABLE moz_cookies (id INTEGER PRIMARY KEY, baseDomain TEXT, originAttributes TEXT NOT NULL DEFAULT '', name TEXT, value TEXT, host TEXT, path TEXT, expiry INTEGER, lastAccessed INTEGER, creationTime INTEGER, isSecure INTEGER, isHttpOnly INTEGER, appId INTEGER DEFAULT 0, inBrowserElement INTEGER DEFAULT 0, CONSTRAINT moz_uniqueid UNIQUE (name, host, path, originAttributes));", (Object)"CREATE INDEX moz_basedomain ON moz_cookies (baseDomain, originAttributes);");

        Sqlite3ProgramImporter() {
        }

        @Override
        public void importCookies(Iterable<DeserializableCookie> cookies, File sqliteDbFile) throws SQLException, IOException {
            Converter cookieExploder = new ExplodedCookieConverter().reverse();
            Converter<Map<String, Object>, Map<String, String>> sqlRowMapper = new FirefoxCookieRowTransform().asConverter();
            Converter cookieToRowTransform = cookieExploder.andThen(sqlRowMapper);
            Iterable rows = Iterables.transform(cookies, (Function)cookieToRowTransform);
            this.importRows(rows, sqliteDbFile);
        }

        private static void checkResult(ProgramWithOutputStringsResult result) throws SQLException, IOException {
            if (result.getExitCode() != 0) {
                log.error("sqlite3 exited with code {}; stderr: {}", (Object)result.getExitCode(), (Object)result.getStderrString());
                throw new SQLException("sqlite3 exited with code " + result.getExitCode() + "; " + StringUtils.abbreviate((String)result.getStderrString(), (int)256));
            }
        }

        private void createTable(File sqliteDbFile) throws SQLException, IOException {
            for (String stmt : CREATE_TABLE_SQL) {
                ProgramWithOutputStrings createTableProgram = Program.running((File)this.resolveSqlite3Executable()).arg(sqliteDbFile.getAbsolutePath()).arg(stmt).outputToStrings();
                ProgramWithOutputStringsResult createTableResult = (ProgramWithOutputStringsResult)createTableProgram.execute();
                Sqlite3ProgramImporter.checkResult(createTableResult);
            }
        }

        private List<String> queryTableNames(File sqliteDbFile) throws SQLException, IOException {
            ProgramWithOutputStringsResult result = (ProgramWithOutputStringsResult)Program.running((File)this.resolveSqlite3Executable()).arg(sqliteDbFile.getAbsolutePath()).arg(".tables").outputToStrings().execute();
            Sqlite3ProgramImporter.checkResult(result);
            ImmutableList tableNames = CharSource.wrap((CharSequence)result.getStdoutString()).readLines();
            return tableNames;
        }

        private Optional<Integer> findMaxValue(File sqliteDbFile, String columnName) throws SQLException, IOException {
            Preconditions.checkArgument((boolean)columnName.matches("[_A-Za-z]\\w*"), (String)"illegal column name: %s", (Object)columnName);
            ProgramWithOutputStringsResult result = (ProgramWithOutputStringsResult)Program.running((File)this.resolveSqlite3Executable()).arg("-csv").arg(sqliteDbFile.getAbsolutePath()).arg("SELECT MAX(" + columnName + ") FROM " + FirefoxCookieDb.TABLE_NAME + " WHERE 1").outputToStrings().execute();
            Sqlite3ProgramImporter.checkResult(result);
            String output = result.getStdoutString().trim();
            if (output.isEmpty()) {
                return Optional.absent();
            }
            return Optional.of((Object)Integer.valueOf(output));
        }

        private void doImportRows(Iterable<Map<String, String>> rows, File sqliteDbFile) throws SQLException, IOException {
            String stdin = Csvs.writeRowMapsToString(sqliteColumnNames, rows, FirefoxCookieDb.DEFAULT_SQLITE_CELL_VALUE, Csvs.UnknownKeyStrategy.IGNORE);
            ProgramWithOutputStrings program = Program.running((File)this.resolveSqlite3Executable()).reading(stdin).arg("-csv").arg(sqliteDbFile.getAbsolutePath()).args(".import /dev/stdin moz_cookies", new String[0]).outputToStrings();
            ProgramWithOutputStringsResult result = (ProgramWithOutputStringsResult)program.execute();
            Sqlite3ProgramImporter.checkResult(result);
        }

        public void importRows(Iterable<Map<String, String>> rows, File sqliteDbFile) throws SQLException, IOException {
            int maxIdValue;
            List<String> tableNames = this.queryTableNames(sqliteDbFile);
            if (!tableNames.contains(FirefoxCookieDb.TABLE_NAME)) {
                this.createTable(sqliteDbFile);
                maxIdValue = 0;
            } else {
                maxIdValue = (Integer)this.findMaxValue(sqliteDbFile, "id").or((Object)0);
            }
            AtomicInteger idFactory = new AtomicInteger(maxIdValue);
            ArrayList<Map<String, String>> rowsWithIds = new ArrayList<Map<String, String>>();
            rows.forEach(row -> rowsWithIds.add(new LinkedHashMap(row)));
            for (Map map : rowsWithIds) {
                map.put("id", String.valueOf(idFactory.incrementAndGet()));
            }
            this.doImportRows(rowsWithIds, sqliteDbFile);
        }

        protected File resolveSqlite3Executable() throws IOException {
            Optional file = Whicher.gnu().which("sqlite3");
            if (file.isPresent()) {
                return (File)file.get();
            }
            throw new FileNotFoundException("sqlite3 executable");
        }
    }

    @VisibleForTesting
    static class Sqlite3ProgramExporter
    implements Exporter {
        Sqlite3ProgramExporter() {
        }

        @Override
        public List<DeserializableCookie> exportCookies(File sqliteDbFile) throws SQLException, IOException {
            throw new UnsupportedOperationException("not yet supported");
        }

        public List<Map<String, String>> dumpRows(File sqliteDbFile) throws SQLException, IOException {
            String sql = "SELECT * FROM moz_cookies WHERE 1";
            if (!FirefoxCookieDb.isSqlite3PresentOnSystemPath()) {
                throw new SQLException("no sqlite3 executable found in search of PATH");
            }
            ProgramWithOutputStringsResult result = (ProgramWithOutputStringsResult)Program.running((String)"sqlite3").arg("-csv").arg("-header").arg(sqliteDbFile.getAbsolutePath()).arg(sql).outputToStrings().execute();
            if (result.getExitCode() != 0) {
                log.warn("sqlite3 exited with code {}; stderr: {}", (Object)result.getExitCode(), (Object)result.getStderrString());
                throw new SQLException("sqlite3 exited with code " + result.getExitCode() + "; " + StringUtils.abbreviate((String)result.getStderrString(), (int)256));
            }
            return Csvs.readRowMaps(CharSource.wrap((CharSequence)result.getStdoutString()), Csvs.headersFromFirstRow());
        }
    }

    public static interface Importer {
        public void importCookies(Iterable<DeserializableCookie> var1, File var2) throws SQLException, IOException;
    }

    public static interface Exporter {
        public List<DeserializableCookie> exportCookies(File var1) throws SQLException, IOException;
    }
}

