/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.github.mike10004.seleniumhelp.DeserializableCookie;
import com.github.mike10004.seleniumhelp.EnvironmentWebDriverFactory;
import com.github.mike10004.seleniumhelp.FirefoxCompatibleCertificateSource;
import com.github.mike10004.seleniumhelp.FirefoxCookieDb;
import com.github.mike10004.xvfbselenium.WebDriverSupport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.lightbody.bmp.BrowserMobProxy;
import net.lightbody.bmp.mitm.CertificateAndKeySource;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;

public class FirefoxWebDriverFactory
extends EnvironmentWebDriverFactory {
    private final Supplier<FirefoxBinary> binarySupplier;
    private final Map<String, Object> profilePreferences;
    private final ImmutableList<DeserializableCookie> cookies;
    private static final ImmutableSet<Class<?>> allowedTypes = ImmutableSet.of(String.class, Integer.class, Boolean.class);
    private static final Predicate<Object> preferenceValueChecker = FirefoxWebDriverFactory.newTypePredicate(allowedTypes);

    public FirefoxWebDriverFactory() {
        this(FirefoxWebDriverFactory.builder());
    }

    protected FirefoxWebDriverFactory(Builder builder) {
        super(builder);
        this.binarySupplier = (Supplier)Preconditions.checkNotNull((Object)builder.binarySupplier);
        this.profilePreferences = ImmutableMap.copyOf((Map)builder.profilePreferences);
        FirefoxWebDriverFactory.checkPreferencesValues(this.profilePreferences.values());
        this.cookies = ImmutableList.copyOf((Collection)builder.cookies);
    }

    protected ImmutableList<DeserializableCookie> getCookies() {
        return this.cookies;
    }

    @Override
    public WebDriver createWebDriver(BrowserMobProxy proxy, @Nullable CertificateAndKeySource certificateAndKeySource) throws IOException {
        ArrayList<SupplementingFirefoxProfile.ProfileAction> actions = new ArrayList<SupplementingFirefoxProfile.ProfileAction>(2);
        ImmutableList<DeserializableCookie> cookies_ = this.getCookies();
        if (!this.cookies.isEmpty()) {
            actions.add(new CookieInstallingProfileAction((List)cookies_, FirefoxCookieDb.getImporter()));
        }
        if (certificateAndKeySource instanceof FirefoxCompatibleCertificateSource) {
            ByteSource certificateDbByteSource = ((FirefoxCompatibleCertificateSource)certificateAndKeySource).getFirefoxCertificateDatabase();
            actions.add(new CertificateSupplementingProfileAction(certificateDbByteSource));
        }
        SupplementingFirefoxProfile profile = new SupplementingFirefoxProfile(actions);
        profile.setPreference("network.proxy.type", 1);
        profile.setPreference("network.proxy.http", "localhost");
        profile.setPreference("network.proxy.http_port", proxy.getPort());
        profile.setPreference("network.proxy.ssl", "localhost");
        profile.setPreference("network.proxy.ssl_port", proxy.getPort());
        profile.setPreference("network.proxy.no_proxies_on", "");
        profile.setPreference("browser.search.geoip.url", "");
        profile.setPreference("network.prefetch-next", false);
        profile.setPreference("network.http.speculative-parallel-limit", 0);
        profile.setPreference("browser.aboutHomeSnippets.updateUrl", "");
        profile.setPreference("extensions.getAddons.cache.enabled", false);
        profile.setPreference("media.gmp-gmpopenh264.enabled", false);
        profile.setPreference("browser.newtabpage.enabled", false);
        profile.setPreference("app.update.url", "");
        profile.setPreference("browser.safebrowsing.provider.mozilla.updateURL", "");
        this.applyAdditionalPreferences(this.profilePreferences, proxy, certificateAndKeySource, profile);
        FirefoxBinary binary = this.binarySupplier.get();
        Map environment = (Map)this.environmentSupplier.get();
        FirefoxDriver driver = WebDriverSupport.firefoxInEnvironment((Map)environment).create(binary, (FirefoxProfile)profile);
        return driver;
    }

    protected void applyAdditionalPreferences(Map<String, Object> profilePreferences, BrowserMobProxy proxy, @Nullable CertificateAndKeySource certificateAndKeySource, FirefoxProfile profile) {
        for (String key : profilePreferences.keySet()) {
            Object value = profilePreferences.get(key);
            if (value instanceof String) {
                profile.setPreference(key, (String)value);
                continue;
            }
            if (value instanceof Integer) {
                profile.setPreference(key, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof Boolean) {
                profile.setPreference(key, ((Boolean)value).booleanValue());
                continue;
            }
            throw new IllegalArgumentException("preference values must be int/string/boolean");
        }
    }

    @VisibleForTesting
    static void checkPreferencesValues(Iterable<?> values) throws IllegalArgumentException {
        for (Object value : values) {
            if (preferenceValueChecker.test(value)) continue;
            throw new IllegalArgumentException(String.format("preference value %s (%s) must have type that is one of %s", value, value == null ? "N/A" : value.getClass(), allowedTypes));
        }
    }

    @VisibleForTesting
    static Predicate<Object> newTypePredicate(Iterable<Class<?>> permittedSuperclasses) {
        ImmutableSet superclasses = ImmutableSet.copyOf(permittedSuperclasses);
        Preconditions.checkArgument((!superclasses.isEmpty() ? 1 : 0) != 0, (Object)"set of superclasses must be nonempty");
        return arg_0 -> FirefoxWebDriverFactory.lambda$newTypePredicate$0((Set)superclasses, arg_0);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static /* synthetic */ boolean lambda$newTypePredicate$0(Set superclasses, Object input) {
        for (Class superclass : superclasses) {
            if (!superclass.isInstance(input)) continue;
            return true;
        }
        return false;
    }

    public static class Builder
    extends EnvironmentWebDriverFactory.Builder<Builder> {
        private Supplier<FirefoxBinary> binarySupplier = FirefoxBinary::new;
        private Map<String, Object> profilePreferences = new LinkedHashMap<String, Object>();
        private List<DeserializableCookie> cookies = new ArrayList<DeserializableCookie>();

        private Builder() {
        }

        public Builder binary(FirefoxBinary binary) {
            return this.binary(() -> binary);
        }

        public Builder binary(Supplier<FirefoxBinary> binarySupplier) {
            this.binarySupplier = (Supplier)Preconditions.checkNotNull(binarySupplier);
            return this;
        }

        public Builder preferences(Map<String, Object> val) {
            this.profilePreferences = (Map)Preconditions.checkNotNull(val);
            return this;
        }

        public Builder putPreferences(Map<String, Object> val) {
            this.profilePreferences.putAll(val);
            return this;
        }

        public Builder cookie(DeserializableCookie cookie) {
            this.cookies.add(cookie);
            return this;
        }

        public Builder addCookies(Iterable<DeserializableCookie> val) {
            Iterables.addAll(this.cookies, val);
            return this;
        }

        public Builder cookies(Iterable<DeserializableCookie> val) {
            this.cookies.clear();
            return this.addCookies(val);
        }

        public Builder preference(String key, boolean value) {
            this.profilePreferences.put(key, value);
            return this;
        }

        public Builder preference(String key, int value) {
            this.profilePreferences.put(key, value);
            return this;
        }

        public Builder preference(String key, String value) {
            this.profilePreferences.put(key, value);
            return this;
        }

        public FirefoxWebDriverFactory build() {
            return new FirefoxWebDriverFactory(this);
        }
    }

    protected static class SupplementingFirefoxProfile
    extends FirefoxProfile {
        private final ImmutableList<? extends ProfileAction> profileActions;

        protected SupplementingFirefoxProfile(Iterable<? extends ProfileAction> profileActions) {
            this.profileActions = ImmutableList.copyOf(profileActions);
        }

        public File layoutOnDisk() {
            File profileDir = super.layoutOnDisk();
            for (ProfileAction action : this.profileActions) {
                action.perform(profileDir);
            }
            return profileDir;
        }

        static interface ProfileAction {
            public void perform(File var1);

            public static class ProfilePreparationException
            extends IllegalStateException {
                public ProfilePreparationException() {
                }

                public ProfilePreparationException(String s) {
                    super(s);
                }

                public ProfilePreparationException(String message, Throwable cause) {
                    super(message, cause);
                }

                public ProfilePreparationException(Throwable cause) {
                    super(cause);
                }
            }
        }
    }

    static class CookieInstallingProfileAction
    implements SupplementingFirefoxProfile.ProfileAction {
        public static final String COOKIES_DB_FILENAME = "cookies.sqlite";
        private final List<DeserializableCookie> cookies;
        private final FirefoxCookieDb.Importer cookieImporter;

        private CookieInstallingProfileAction(List<DeserializableCookie> cookies, FirefoxCookieDb.Importer cookieImporter) {
            this.cookies = (List)Preconditions.checkNotNull(cookies);
            this.cookieImporter = (FirefoxCookieDb.Importer)Preconditions.checkNotNull((Object)cookieImporter);
        }

        @Override
        public void perform(File profileDir) {
            File sqliteDbFile = new File(profileDir, COOKIES_DB_FILENAME);
            try {
                this.cookieImporter.importCookies(this.cookies, sqliteDbFile);
            }
            catch (IOException | SQLException e) {
                throw new SupplementingFirefoxProfile.ProfileAction.ProfilePreparationException("failed to install cookies into " + sqliteDbFile, e);
            }
        }
    }

    private static class CertificateSupplementingProfileAction
    implements SupplementingFirefoxProfile.ProfileAction {
        public static final String CERTIFICATE_DB_FILENAME = "cert8.db";
        private final ByteSource certificateDbSource;

        private CertificateSupplementingProfileAction(ByteSource certificateDbSource) {
            this.certificateDbSource = (ByteSource)Preconditions.checkNotNull((Object)certificateDbSource);
        }

        @Override
        public void perform(File profileDir) {
            File certificateDbFile = new File(profileDir, CERTIFICATE_DB_FILENAME);
            try {
                this.certificateDbSource.copyTo(Files.asByteSink((File)certificateDbFile, (FileWriteMode[])new FileWriteMode[0]));
            }
            catch (IOException e) {
                throw new SupplementingFirefoxProfile.ProfileAction.ProfilePreparationException("failed to copy certificate database to profile dir " + profileDir, e);
            }
        }
    }
}

