/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.github.mike10004.seleniumhelp.CookieCollection;
import com.github.mike10004.seleniumhelp.FlexibleCookieSpec;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Date;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.lightbody.bmp.core.har.Har;
import net.lightbody.bmp.core.har.HarEntry;
import net.lightbody.bmp.core.har.HarNameValuePair;
import net.lightbody.bmp.core.har.HarPostData;
import net.lightbody.bmp.core.har.HarRequest;
import net.lightbody.bmp.core.har.HarResponse;
import org.apache.commons.lang3.tuple.Pair;

public class HarAnalysis {
    private final Har har;

    private HarAnalysis(Har har) {
        this.har = (Har)Preconditions.checkNotNull((Object)har);
    }

    public static HarAnalysis of(Har har) {
        return new HarAnalysis(har);
    }

    public CookieCollection findCookies() {
        return this.findCookies(FlexibleCookieSpec.getDefault());
    }

    CookieCollection findCookies(FlexibleCookieSpec cookieSpec) {
        return this.findCookies(cookieSpec, HarEntry::getStartedDateTime);
    }

    public CookieCollection findCookies(Function<HarEntry, Date> creationDateGetter) {
        return this.findCookies(FlexibleCookieSpec.getDefault(), creationDateGetter);
    }

    CookieCollection findCookies(FlexibleCookieSpec cookieSpec, Function<HarEntry, Date> creationDateGetter) {
        Stream<HarEntry> headerValues = this.findEntriesWithSetCookieHeaders();
        return CookieCollection.build(headerValues, cookieSpec);
    }

    public Stream<HarEntry> findEntriesWithSetCookieHeaders() {
        Stream<HarEntry> entriesWithCookieHeaders = this.har.getLog().getEntries().stream().filter(HarAnalysis.entryPredicate(HarAnalysis.anyRequest(), input -> input != null && input.getHeaders().stream().anyMatch(hnvp -> "Set-Cookie".equalsIgnoreCase(hnvp.getName()))));
        return entriesWithCookieHeaders;
    }

    public Stream<Pair<HarRequest, Stream<String>>> findCookieHeaderValues() {
        Stream<HarEntry> entriesWithCookieHeaders = this.findEntriesWithSetCookieHeaders();
        Stream<Pair<HarRequest, HarResponse>> interactionsWithCookieHeaders = entriesWithCookieHeaders.map(HarAnalysis.entryToInteraction());
        Stream<Pair<HarRequest, Stream<String>>> mappedInteractions = interactionsWithCookieHeaders.map(HarAnalysis.rightTransform(HarAnalysis.responseHeaderTransform("Set-Cookie")));
        return mappedInteractions;
    }

    public static Function<HarResponse, Stream<String>> responseHeaderTransform(String requiredHeaderName) {
        Preconditions.checkNotNull((Object)requiredHeaderName);
        return input -> {
            Stream<HarNameValuePair> stream = input.getHeaders().stream().filter(harNameValuePair -> requiredHeaderName.equalsIgnoreCase(harNameValuePair.getName()));
            return stream.map(HarNameValuePair::getValue);
        };
    }

    public static Function<HarEntry, Pair<HarRequest, HarResponse>> entryToInteraction() {
        return input -> Pair.of((Object)input.getRequest(), (Object)input.getResponse());
    }

    public static Predicate<HarEntry> entryPredicate(Predicate<HarRequest> requestPredicate, Predicate<HarResponse> responsePredicate) {
        return harEntry -> harEntry != null && requestPredicate.test(harEntry.getRequest()) && responsePredicate.test(harEntry.getResponse());
    }

    public static Predicate<HarRequest> anyRequest() {
        return harRequest -> true;
    }

    public static Predicate<HarResponse> anyResponse() {
        return harResponse -> true;
    }

    public static <L1, R1, L2, R2> Function<Pair<L1, R1>, Pair<L2, R2>> pairTransform(Function<L1, L2> left, Function<R1, R2> right) {
        return input -> Pair.of(left.apply(input.getLeft()), right.apply(input.getRight()));
    }

    public static <L, R1, R2> Function<Pair<L, R1>, Pair<L, R2>> rightTransform(Function<R1, R2> right) {
        return HarAnalysis.pairTransform(Function.identity(), right);
    }

    public static String describe(HarRequest request) {
        if (request == null) {
            return "null";
        }
        return MoreObjects.toStringHelper((Object)request).add("method", (Object)request.getMethod()).add("url", (Object)request.getUrl()).add("headers.count", HarAnalysis.sizeOf(request.getHeaders())).add("postData", (Object)request.getPostData()).toString();
    }

    private static int lengthOf(@Nullable String str) {
        return str == null ? -1 : str.length();
    }

    private static int sizeOf(@Nullable Collection<?> collection) {
        return collection == null ? -1 : collection.size();
    }

    public static String describe(HarResponse response) {
        if (response == null) {
            return "null";
        }
        return MoreObjects.toStringHelper((Object)response).add("status", response.getStatus()).add("headers.count", HarAnalysis.sizeOf(response.getHeaders())).add("bodySize", response.getBodySize()).toString();
    }

    public static String describe(HarPostData postData) {
        if (postData == null) {
            return "null";
        }
        return MoreObjects.toStringHelper((Object)postData).add("params.size", HarAnalysis.sizeOf(postData.getParams())).add("text.length", HarAnalysis.lengthOf(postData.getText())).add("mimeType", (Object)postData.getMimeType()).toString();
    }
}

