/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.github.mike10004.seleniumhelp.HarPostProcessor;
import com.google.common.base.CharMatcher;
import com.google.common.io.ByteStreams;
import com.google.common.net.MediaType;
import com.helger.css.ECSSVersion;
import com.helger.css.reader.CSSReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import jdk.nashorn.internal.parser.Parser;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ErrorManager;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.options.Options;
import net.lightbody.bmp.core.har.Har;
import net.lightbody.bmp.core.har.HarContent;
import net.lightbody.bmp.core.har.HarEntry;
import net.lightbody.bmp.core.har.HarNameValuePair;
import net.lightbody.bmp.core.har.HarResponse;
import org.brotli.dec.BrotliInputStream;

public class HarCleaner {
    static final String HEADER_VALUE_BROTLI_ENCODED = "br";
    private static final CharMatcher base64Alphabet = CharMatcher.javaLetterOrDigit().or(CharMatcher.anyOf((CharSequence)"/+="));

    public HarPostProcessor asPostProcessor() {
        return this::clean;
    }

    public List<HarEntry> clean(Har inputHar) {
        List<HarEntry> entries = inputHar.getLog().getEntries().stream().filter(entry -> {
            HarResponse rsp = entry.getResponse();
            HarContent content = rsp.getContent();
            String contentEncoding = HarCleaner.getHeaderValue(rsp.getHeaders(), "Content-Encoding");
            if (HEADER_VALUE_BROTLI_ENCODED.equalsIgnoreCase(contentEncoding) && content != null) {
                String text = content.getText();
                if (HarCleaner.base64Alphabet().matchesAllOf((CharSequence)text)) {
                    return true;
                }
            }
            return false;
        }).collect(Collectors.toList());
        this.clean(entries.stream());
        return entries;
    }

    private static boolean isContentType(Predicate<? super MediaType> predicate, @Nullable String contentType) {
        if (contentType != null && !"".equals(contentType.trim())) {
            MediaType mediaType = MediaType.parse((String)contentType.trim());
            return predicate.test((MediaType)mediaType);
        }
        return false;
    }

    private static boolean isJavascriptContentType(@Nullable String contentType) {
        return HarCleaner.isContentType(mediaType -> "javascript".equalsIgnoreCase(mediaType.subtype()), contentType);
    }

    protected void cleaningExceptionThrown(HarResponse response, Exception exception) {
    }

    protected void clean(Stream<HarEntry> entries) {
        entries.map(HarEntry::getResponse).forEach(response -> {
            try {
                this.clean((HarResponse)response);
            }
            catch (IOException e) {
                this.cleaningExceptionThrown((HarResponse)response, e);
            }
        });
    }

    protected Charset divineCharset(HarResponse response) {
        return StandardCharsets.UTF_8;
    }

    protected void clean(HarResponse response) throws IOException {
        String encoding;
        String text;
        byte[] decompressed;
        HarContent content = response.getContent();
        byte[] brotliBytes = Base64.getDecoder().decode(content.getText());
        try (BrotliInputStream in = new BrotliInputStream((InputStream)new ByteArrayInputStream(brotliBytes));){
            decompressed = ByteStreams.toByteArray((InputStream)in);
        }
        if (HarCleaner.isJavascriptContentType(content.getMimeType())) {
            text = new String(decompressed, this.divineCharset(response));
            encoding = null;
            if (!this.isValidJavascript(text)) {
                throw new DecodedContentException("not valid javascript");
            }
        } else if (HarCleaner.isContentType(m -> m.is(MediaType.CSS_UTF_8.withoutParameters()), content.getMimeType())) {
            text = new String(decompressed, this.divineCharset(response));
            encoding = null;
            if (!this.isValidCss(text)) {
                throw new DecodedContentException("not valid css");
            }
        } else {
            text = Base64.getEncoder().encodeToString(decompressed);
            encoding = "base64";
        }
        content.setEncoding(encoding);
        content.setText(text);
    }

    protected boolean isValidCss(String sourceCode) {
        for (ECSSVersion cssVersion : ECSSVersion.values()) {
            if (!CSSReader.isValidCSS((String)sourceCode, (ECSSVersion)cssVersion)) continue;
            return true;
        }
        return false;
    }

    private static CharMatcher base64Alphabet() {
        return base64Alphabet;
    }

    @Nullable
    private static String getHeaderValue(Iterable<HarNameValuePair> headers, String headerName) {
        for (HarNameValuePair header : headers) {
            if (!headerName.equalsIgnoreCase(header.getName())) continue;
            return header.getValue();
        }
        return null;
    }

    protected boolean isValidJavascript(String sourceCode) {
        Options options = new Options("nashorn");
        options.set("anon.functions", true);
        options.set("parse.only", true);
        options.set("scripting", true);
        ErrorManager errors = new ErrorManager();
        Context context = new Context(options, errors, Thread.currentThread().getContextClassLoader());
        Source source = Source.sourceFor((String)"test", (String)sourceCode);
        Parser parser = new Parser(context.getEnv(), source, errors);
        parser.parse();
        return !errors.hasErrors();
    }

    static class DecodedContentException
    extends IOException {
        public DecodedContentException(String message) {
            super(message);
        }

        public DecodedContentException(String message, Throwable cause) {
            super(message, cause);
        }

        public DecodedContentException(Throwable cause) {
            super(cause);
        }
    }
}

