/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.github.mike10004.seleniumhelp.HarAnalysis;
import com.github.mike10004.seleniumhelp.ImmutableHttpMessage;
import com.github.mike10004.seleniumhelp.ImmutableHttpRequest;
import com.github.mike10004.seleniumhelp.ImmutableHttpResponse;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.io.CharSource;
import com.google.common.net.MediaType;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.lightbody.bmp.core.har.HarContent;
import net.lightbody.bmp.core.har.HarPostData;
import net.lightbody.bmp.core.har.HarPostDataParam;
import net.lightbody.bmp.core.har.HarRequest;
import net.lightbody.bmp.core.har.HarResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.LoggerFactory;

final class HarInteractions {
    private HarInteractions() {
    }

    private static boolean isNullOrEmpty(@Nullable Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    private static Function<HarPostDataParam, NameValuePair> paramToPair() {
        return param -> new BasicNameValuePair(param.getName(), param.getValue());
    }

    @VisibleForTesting
    static Optional<Charset> maybeGetCharset(@Nullable String contentType) {
        if (contentType != null) {
            try {
                return Optional.ofNullable(MediaType.parse((String)contentType).charset().orNull());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    @VisibleForTesting
    static ImmutableHttpMessage.HttpContentSource toContentSource(@Nullable HarPostData postData) {
        if (postData == null || HarInteractions.isNullOrEmpty(postData.getParams()) && Strings.isNullOrEmpty((String)postData.getText())) {
            return ImmutableHttpMessage.HttpContentSource.empty();
        }
        if (!Strings.isNullOrEmpty((String)postData.getText())) {
            return ImmutableHttpMessage.HttpContentSource.fromChars(CharSource.wrap((CharSequence)postData.getText()));
        }
        if (!HarInteractions.isNullOrEmpty(postData.getParams())) {
            Charset charset = HarInteractions.maybeGetCharset(postData.getMimeType()).orElse(StandardCharsets.UTF_8);
            String encodedForm = URLEncodedUtils.format((Iterable)postData.getParams().stream().map(HarInteractions.paramToPair()).collect(Collectors.toList()), (Charset)charset);
            return ImmutableHttpMessage.HttpContentSource.fromChars(CharSource.wrap((CharSequence)encodedForm));
        }
        LoggerFactory.getLogger(HarInteractions.class).warn("could not transform nonempty post data to nonempty content source: {}", (Object)HarAnalysis.describe(postData));
        return ImmutableHttpMessage.HttpContentSource.empty();
    }

    @VisibleForTesting
    static ImmutableHttpMessage.HttpContentSource toContentSource(@Nullable HarContent content) {
        if (content == null || Strings.isNullOrEmpty((String)content.getText())) {
            return ImmutableHttpMessage.HttpContentSource.empty();
        }
        if ("base64".equals(content.getEncoding())) {
            return ImmutableHttpMessage.HttpContentSource.fromBase64(content.getText());
        }
        return ImmutableHttpMessage.HttpContentSource.fromChars(CharSource.wrap((CharSequence)content.getText()));
    }

    @VisibleForTesting
    static URI parseUri(String uriStr) {
        try {
            URL url = new URL(uriStr);
            return new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ImmutableHttpRequest freeze(HarRequest harRequest) {
        if (harRequest.getUrl() == null) {
            throw new IllegalArgumentException("url is null in " + HarAnalysis.describe(harRequest));
        }
        return ((ImmutableHttpRequest.Builder)((ImmutableHttpRequest.Builder)ImmutableHttpRequest.builder(HarInteractions.parseUri(harRequest.getUrl())).method(Optional.ofNullable(harRequest.getMethod()).orElse("GET")).addHeaders(harRequest.getHeaders().stream().map(pair -> new AbstractMap.SimpleImmutableEntry<String, String>(pair.getName(), pair.getValue())))).content(HarInteractions.toContentSource(harRequest.getPostData()))).build();
    }

    public static ImmutableHttpResponse freeze(HarResponse harResponse) {
        return ((ImmutableHttpResponse.Builder)((ImmutableHttpResponse.Builder)ImmutableHttpResponse.builder(harResponse.getStatus()).addHeaders(harResponse.getHeaders().stream().map(pair -> new AbstractMap.SimpleImmutableEntry<String, String>(pair.getName(), pair.getValue())))).content(HarInteractions.toContentSource(harResponse.getContent()))).build();
    }
}

