/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ImmutableHttpHeaders
extends HttpHeaders {
    private final HttpHeaders inner;
    private final ImmutableList<Map.Entry<String, String>> entries;
    private final ImmutableSet<String> names;

    public ImmutableHttpHeaders(HttpHeaders inner) {
        this.inner = inner;
        this.entries = ImmutableList.copyOf((Collection)inner.entries().stream().map(input -> {
            Preconditions.checkNotNull((Object)input);
            if (input instanceof AbstractMap.SimpleImmutableEntry) {
                return (AbstractMap.SimpleImmutableEntry)input;
            }
            return new AbstractMap.SimpleImmutableEntry(input.getKey(), input.getValue());
        }).collect(Collectors.toList()));
        this.names = ImmutableSet.copyOf((Collection)inner.names());
    }

    public static java.util.function.Supplier<HttpHeaders> asSupplier(HttpMessage message) {
        return () -> new ImmutableHttpHeaders(message.headers());
    }

    public static java.util.function.Supplier<HttpHeaders> memoize(HttpMessage message) {
        return () -> ((Supplier)Suppliers.memoize(((java.util.function.Supplier<HttpHeaders>)ImmutableHttpHeaders.asSupplier(message))::get)).get();
    }

    public String get(String name) {
        return this.inner.get(name);
    }

    public String get(CharSequence name) {
        return this.inner.get(name);
    }

    public List<String> getAll(String name) {
        return this.inner.getAll(name);
    }

    public List<String> getAll(CharSequence name) {
        return this.inner.getAll(name);
    }

    public List<Map.Entry<String, String>> entries() {
        return this.entries;
    }

    public boolean contains(String name) {
        return this.inner.contains(name);
    }

    public boolean contains(CharSequence name) {
        return this.inner.contains(name);
    }

    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    public Set<String> names() {
        return this.names;
    }

    public HttpHeaders add(String name, Object value) {
        return this.inner.add(name, value);
    }

    public HttpHeaders add(CharSequence name, Object value) {
        return this.inner.add(name, value);
    }

    public HttpHeaders add(String name, Iterable<?> values) {
        return this.inner.add(name, values);
    }

    public HttpHeaders add(CharSequence name, Iterable<?> values) {
        return this.inner.add(name, values);
    }

    public HttpHeaders add(HttpHeaders headers) {
        return this.inner.add(headers);
    }

    public HttpHeaders set(String name, Object value) {
        throw new UnsupportedOperationException("immutable");
    }

    public HttpHeaders set(CharSequence name, Object value) {
        throw new UnsupportedOperationException("immutable");
    }

    public HttpHeaders set(String name, Iterable<?> values) {
        throw new UnsupportedOperationException("immutable");
    }

    public HttpHeaders set(CharSequence name, Iterable<?> values) {
        throw new UnsupportedOperationException("immutable");
    }

    public HttpHeaders set(HttpHeaders headers) {
        throw new UnsupportedOperationException("immutable");
    }

    public HttpHeaders remove(String name) {
        throw new UnsupportedOperationException("immutable");
    }

    public HttpHeaders remove(CharSequence name) {
        throw new UnsupportedOperationException("immutable");
    }

    public HttpHeaders clear() {
        throw new UnsupportedOperationException("immutable");
    }

    public boolean contains(String name, String value, boolean ignoreCaseValue) {
        return this.inner.contains(name, value, ignoreCaseValue);
    }

    public boolean containsValue(CharSequence name, CharSequence value, boolean ignoreCase) {
        return this.inner.containsValue(name, value, ignoreCase);
    }

    public boolean contains(CharSequence name, CharSequence value, boolean ignoreCaseValue) {
        return this.inner.contains(name, value, ignoreCaseValue);
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        return new IteratorNotSupportingRemove<Map.Entry<String, String>>(this.inner.iterator());
    }

    public String toString() {
        return this.inner.toString();
    }

    private static class IteratorNotSupportingRemove<E>
    implements Iterator<E> {
        private final Iterator<E> inner;

        public IteratorNotSupportingRemove(Iterator<E> inner) {
            this.inner = (Iterator)Preconditions.checkNotNull(inner);
        }

        @Override
        public boolean hasNext() {
            return this.inner.hasNext();
        }

        @Override
        public E next() {
            return this.inner.next();
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            this.inner.forEachRemaining(action);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported");
        }
    }
}

