/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.io.input.ReaderInputStream;

public class ImmutableHttpMessage {
    public static final Charset DEFAULT_HTTP_CHARSET = StandardCharsets.ISO_8859_1;
    private final HttpContentSource dataSource;
    public final ImmutableMultimap<String, String> headers;

    protected ImmutableHttpMessage(MessageBuilder<?> builder) {
        this.dataSource = ((MessageBuilder)builder).dataSource;
        this.headers = ImmutableMultimap.copyOf((Multimap)((MessageBuilder)builder).headers);
    }

    protected MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("contentSource", (Object)this.dataSource).add("headers.size", this.headers.size());
    }

    public ByteSource getContentAsBytes() {
        return this.dataSource.asBytes(this);
    }

    public CharSource getContentAsChars() {
        return this.dataSource.asChars(this);
    }

    protected static CharSource encodeToBase64(final ByteSource byteSource) {
        return new CharSource(){

            public Reader openStream() throws IOException {
                return new StringReader(Base64.getEncoder().encodeToString(byteSource.read()));
            }
        };
    }

    protected static ByteSource encodeToBytes(final CharSource charSource, final Supplier<Charset> charsetSupplier) {
        return new ByteSource(){

            public InputStream openStream() throws IOException {
                return new ReaderInputStream(charSource.openStream(), (Charset)charsetSupplier.get());
            }

            public InputStream openBufferedStream() throws IOException {
                return new ReaderInputStream((Reader)charSource.openBufferedStream(), (Charset)charsetSupplier.get());
            }
        };
    }

    public Stream<Map.Entry<String, String>> getHeaders(String headerName) {
        Preconditions.checkNotNull((Object)headerName);
        return this.headers.entries().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(headerName));
    }

    public Stream<String> getHeaderValues(String headerName) {
        return this.getHeaders(headerName).map(Map.Entry::getValue);
    }

    @Nullable
    public MediaType getContentType() {
        String headerValue = this.getFirstHeaderValue("Content-Type");
        if (headerValue == null) {
            return null;
        }
        return MediaType.parse((String)headerValue);
    }

    @Nullable
    public String getFirstHeaderValue(String headerName) {
        return this.getHeaders(headerName).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    public static abstract class MessageBuilder<B extends MessageBuilder> {
        private HttpContentSource dataSource = HttpContentSource.empty();
        private final Multimap<String, String> headers = ArrayListMultimap.create();

        protected MessageBuilder() {
        }

        public B content(HttpContentSource contentSource) {
            this.dataSource = (HttpContentSource)Preconditions.checkNotNull((Object)contentSource);
            return (B)this;
        }

        public B content(ByteSource byteSource) {
            this.dataSource = new OriginalByteSource(byteSource);
            return (B)this;
        }

        public B content(CharSource charSource) {
            this.dataSource = new OriginalCharSource(charSource);
            return (B)this;
        }

        public B headers(Multimap<String, String> val) {
            this.headers.clear();
            this.headers.putAll(val);
            return (B)this;
        }

        public B addHeaders(Collection<? extends Map.Entry<String, String>> headers) {
            return this.addHeaders(headers.stream());
        }

        public B addHeaders(Stream<? extends Map.Entry<String, String>> headers) {
            headers.forEach(entry -> this.headers.put(entry.getKey(), entry.getValue()));
            return (B)this;
        }
    }

    protected static final class OriginalCharSource
    implements HttpContentSource {
        private final CharSource charSource;

        public OriginalCharSource(CharSource charSource) {
            this.charSource = (CharSource)Preconditions.checkNotNull((Object)charSource);
        }

        @Override
        public boolean isNativelyText() {
            return true;
        }

        @Override
        public CharSource asChars(ImmutableHttpMessage message) {
            return this.charSource;
        }

        @Override
        public ByteSource asBytes(ImmutableHttpMessage message) {
            MediaType contentType = message.getContentType();
            Charset charset = contentType != null && contentType.charset().isPresent() ? (Charset)contentType.charset().get() : DEFAULT_HTTP_CHARSET;
            return ImmutableHttpMessage.encodeToBytes(this.charSource, () -> charset);
        }

        public String toString() {
            return "OriginalCharSource{nativelyText=" + this.isNativelyText() + ",charSource.length=" + this.charSource.lengthIfKnown() + '}';
        }
    }

    protected static final class OriginalByteSource
    implements HttpContentSource {
        private final ByteSource byteSource;

        public OriginalByteSource(ByteSource byteSource) {
            this.byteSource = (ByteSource)Preconditions.checkNotNull((Object)byteSource);
        }

        @Override
        public CharSource asChars(ImmutableHttpMessage message) {
            return ImmutableHttpMessage.encodeToBase64(this.byteSource);
        }

        @Override
        public ByteSource asBytes(ImmutableHttpMessage message) {
            return this.byteSource;
        }

        @Override
        public boolean isNativelyText() {
            return false;
        }

        public String toString() {
            return "OriginalByteSource{nativelyText=" + this.isNativelyText() + ",byteSource.size=" + this.byteSource.sizeIfKnown() + '}';
        }
    }

    public static interface HttpContentSource {
        public boolean isNativelyText();

        public CharSource asChars(ImmutableHttpMessage var1);

        public ByteSource asBytes(ImmutableHttpMessage var1);

        public static HttpContentSource empty() {
            return new HttpContentSource(){

                @Override
                public boolean isNativelyText() {
                    return false;
                }

                @Override
                public CharSource asChars(ImmutableHttpMessage message) {
                    return CharSource.empty();
                }

                @Override
                public ByteSource asBytes(ImmutableHttpMessage message) {
                    return ByteSource.empty();
                }

                public String toString() {
                    return "HttpContentSource{empty}";
                }
            };
        }

        public static HttpContentSource fromBytes(ByteSource byteSource) {
            return new OriginalByteSource(byteSource);
        }

        public static HttpContentSource fromChars(CharSource charSource) {
            return new OriginalCharSource(charSource);
        }

        public static HttpContentSource fromBase64(String base64Data) {
            return new OriginalByteSource(Base64ByteSource.forBase64String(base64Data));
        }
    }

    protected static class Base64ByteSource
    extends ByteSource {
        private final String base64Data;
        private final Supplier<Base64.Decoder> decoderSupplier;

        public static Base64ByteSource forBase64String(String base64Data) {
            return new Base64ByteSource(base64Data, Base64::getDecoder);
        }

        private Base64ByteSource(String base64Data, Supplier<Base64.Decoder> decoderSupplier) {
            this.base64Data = (String)Preconditions.checkNotNull((Object)base64Data);
            this.decoderSupplier = (Supplier)Preconditions.checkNotNull(decoderSupplier);
        }

        public InputStream openStream() throws IOException {
            return this.decoderSupplier.get().wrap((InputStream)new ReaderInputStream((Reader)new StringReader(this.base64Data), StandardCharsets.US_ASCII));
        }
    }
}

