/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.github.mike10004.seleniumhelp.ImmutableHttpMessage;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMultimap;
import io.netty.handler.codec.http.HttpMethod;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class ImmutableHttpRequest
extends ImmutableHttpMessage {
    public final String method;
    public final URI url;
    private final transient Object paramsLock = new Object();
    private volatile ImmutableMultimap<String, String> queryParams;

    private ImmutableHttpRequest(Builder builder) {
        super(builder);
        this.method = (String)Preconditions.checkNotNull((Object)builder.method);
        this.url = (URI)Preconditions.checkNotNull((Object)builder.url);
    }

    public String toString() {
        return this.toStringHelper().add("method", (Object)this.method).add("url", (Object)StringUtils.abbreviate((String)this.url.toString(), (int)128)).toString();
    }

    public static Builder builder(URI requestUrl) {
        return new Builder(requestUrl);
    }

    public ImmutableMultimap<String, String> parseQueryParams() {
        return this.parseQueryParams(StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableMultimap<String, String> parseQueryParams(Charset charset) {
        Object object = this.paramsLock;
        synchronized (object) {
            if (this.queryParams == null) {
                List nameValuePairs = URLEncodedUtils.parse((URI)this.url, (String)charset.name());
                ImmutableMultimap.Builder b = ImmutableMultimap.builder();
                for (NameValuePair nameValuePair : nameValuePairs) {
                    b.put((Object)Strings.nullToEmpty((String)nameValuePair.getName()), (Object)Strings.nullToEmpty((String)nameValuePair.getValue()));
                }
                this.queryParams = b.build();
            }
            return this.queryParams;
        }
    }

    public static final class Builder
    extends ImmutableHttpMessage.MessageBuilder<Builder> {
        private String method = "GET";
        private final URI url;

        private Builder(URI url) {
            this.url = (URI)Preconditions.checkNotNull((Object)url);
        }

        public Builder method(String method) {
            this.method = HttpMethod.valueOf((String)method).name();
            return this;
        }

        public ImmutableHttpRequest build() {
            return new ImmutableHttpRequest(this);
        }
    }
}

