/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.github.mike10004.seleniumhelp.AnonymizingFiltersSource;
import com.github.mike10004.seleniumhelp.HarPlus;
import com.github.mike10004.seleniumhelp.HarPostProcessor;
import com.github.mike10004.seleniumhelp.TrafficGenerator;
import com.github.mike10004.seleniumhelp.TrafficMonitor;
import com.github.mike10004.seleniumhelp.TrafficMonitorFilter;
import com.github.mike10004.seleniumhelp.WebDriverFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.lightbody.bmp.BrowserMobProxy;
import net.lightbody.bmp.BrowserMobProxyServer;
import net.lightbody.bmp.core.har.Har;
import net.lightbody.bmp.mitm.CertificateAndKeySource;
import net.lightbody.bmp.mitm.manager.ImpersonatingMitmManager;
import net.lightbody.bmp.proxy.CaptureType;
import org.littleshoot.proxy.HttpFilters;
import org.littleshoot.proxy.HttpFiltersSource;
import org.littleshoot.proxy.HttpFiltersSourceAdapter;
import org.littleshoot.proxy.MitmManager;
import org.littleshoot.proxy.impl.ProxyUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;

public class TrafficCollector {
    private final WebDriverFactory webDriverFactory;
    @Nullable
    private final CertificateAndKeySource certificateAndKeySource;
    private final ImmutableList<HttpFiltersSource> httpFiltersSources;
    private final Supplier<InetSocketAddress> upstreamProxyProvider;
    private final Supplier<BrowserMobProxy> localProxyInstantiator;
    private final ImmutableList<HarPostProcessor> harPostProcessors;

    protected TrafficCollector(WebDriverFactory webDriverFactory, @Nullable CertificateAndKeySource certificateAndKeySource, Supplier<InetSocketAddress> upstreamProxyProvider, Iterable<? extends HttpFiltersSource> httpFiltersSources, Supplier<BrowserMobProxy> localProxyInstantiator, Iterable<? extends HarPostProcessor> harPostProcessors) {
        this.webDriverFactory = (WebDriverFactory)Preconditions.checkNotNull((Object)webDriverFactory);
        this.certificateAndKeySource = certificateAndKeySource;
        this.httpFiltersSources = ImmutableList.copyOf(httpFiltersSources);
        this.upstreamProxyProvider = (Supplier)Preconditions.checkNotNull(upstreamProxyProvider);
        this.localProxyInstantiator = (Supplier)Preconditions.checkNotNull(localProxyInstantiator);
        this.harPostProcessors = ImmutableList.copyOf(harPostProcessors);
    }

    private TrafficCollector(Builder builder) {
        this(builder.webDriverFactory, builder.certificateAndKeySource, builder.upstreamProxyProvider, builder.httpFiltersSources, builder.localProxyInstantiator, builder.harPostProcessors);
    }

    public static Builder builder(WebDriverFactory webDriverFactory) {
        return new Builder(webDriverFactory);
    }

    protected Set<CaptureType> getCaptureTypes() {
        return EnumSet.allOf(CaptureType.class);
    }

    public <R> HarPlus<R> collect(TrafficGenerator<R> generator) throws IOException, WebDriverException {
        return this.collect(generator, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> HarPlus<R> collect(TrafficGenerator<R> generator, @Nullable TrafficMonitor monitor) throws IOException, WebDriverException {
        R result;
        Preconditions.checkNotNull(generator, (Object)"generator");
        BrowserMobProxy bmp = this.instantiateProxy();
        this.configureProxy(bmp, this.certificateAndKeySource);
        bmp.enableHarCaptureTypes(this.getCaptureTypes());
        bmp.newHar();
        if (monitor != null) {
            this.addTrafficMonitorFilter(bmp, monitor);
        }
        bmp.start();
        try {
            result = this.invokeGenerate(bmp, generator);
        }
        finally {
            bmp.stop();
        }
        Har har = bmp.getHar();
        for (HarPostProcessor harPostProcessor : this.harPostProcessors) {
            harPostProcessor.process(har);
        }
        return new HarPlus<R>(har, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R monitor(TrafficGenerator<R> generator, TrafficMonitor monitor) throws IOException, WebDriverException {
        Preconditions.checkNotNull(generator, (Object)"generator");
        Preconditions.checkNotNull((Object)monitor, (Object)"monitor");
        BrowserMobProxy bmp = this.instantiateProxy();
        this.configureProxy(bmp, this.certificateAndKeySource);
        this.addTrafficMonitorFilter(bmp, monitor);
        bmp.start();
        try {
            R r = this.invokeGenerate(bmp, generator);
            return r;
        }
        finally {
            bmp.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R invokeGenerate(BrowserMobProxy bmp, TrafficGenerator<R> generator) throws IOException, WebDriverException {
        WebDriver driver = this.webDriverFactory.createWebDriver(bmp, this.certificateAndKeySource);
        try {
            R r = generator.generate(driver);
            return r;
        }
        finally {
            driver.quit();
        }
    }

    protected void addTrafficMonitorFilter(BrowserMobProxy bmp, final TrafficMonitor monitor) {
        Preconditions.checkNotNull((Object)monitor, (Object)"monitor");
        bmp.addLastHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                if (!ProxyUtils.isCONNECT((HttpObject)originalRequest)) {
                    return new TrafficMonitorFilter(originalRequest, ctx, monitor);
                }
                return null;
            }
        });
    }

    protected MitmManager createMitmManager(BrowserMobProxy proxy, CertificateAndKeySource certificateAndKeySource) {
        ImpersonatingMitmManager mitmManager = ImpersonatingMitmManager.builder().rootCertificateSource(certificateAndKeySource).build();
        return mitmManager;
    }

    protected BrowserMobProxy instantiateProxy() {
        return this.localProxyInstantiator.get();
    }

    protected void configureProxy(BrowserMobProxy bmp, CertificateAndKeySource certificateAndKeySource) {
        if (certificateAndKeySource != null) {
            MitmManager mitmManager = this.createMitmManager(bmp, certificateAndKeySource);
            bmp.setMitmManager(mitmManager);
        }
        this.httpFiltersSources.forEach(arg_0 -> ((BrowserMobProxy)bmp).addLastHttpFilterFactory(arg_0));
        InetSocketAddress upstreamProxy = this.upstreamProxyProvider.get();
        if (upstreamProxy != null) {
            bmp.setChainedProxy(upstreamProxy);
        }
    }

    public static final class Builder {
        private final WebDriverFactory webDriverFactory;
        private CertificateAndKeySource certificateAndKeySource = null;
        private final List<HttpFiltersSource> httpFiltersSources = new ArrayList<HttpFiltersSource>();
        private Supplier<InetSocketAddress> upstreamProxyProvider = () -> null;
        private Supplier<BrowserMobProxy> localProxyInstantiator = BrowserMobProxyServer::new;
        private final List<HarPostProcessor> harPostProcessors = new ArrayList<HarPostProcessor>();

        private Builder(WebDriverFactory webDriverFactory) {
            this.webDriverFactory = (WebDriverFactory)Preconditions.checkNotNull((Object)webDriverFactory);
            this.httpFiltersSources.add(AnonymizingFiltersSource.getInstance());
        }

        public Builder collectHttps(CertificateAndKeySource certificateAndKeySource) {
            this.certificateAndKeySource = (CertificateAndKeySource)Preconditions.checkNotNull((Object)certificateAndKeySource);
            return this;
        }

        public Builder localProxyInstantiator(Supplier<BrowserMobProxy> localProxyInstantiator) {
            this.localProxyInstantiator = (Supplier)Preconditions.checkNotNull(localProxyInstantiator);
            return this;
        }

        public Builder nonAnonymizing() {
            this.httpFiltersSources.remove(AnonymizingFiltersSource.getInstance());
            return this;
        }

        public Builder filter(HttpFiltersSource filter) {
            this.httpFiltersSources.add(filter);
            return this;
        }

        public Builder filters(Collection<? extends HttpFiltersSource> val) {
            this.httpFiltersSources.addAll(val);
            return this;
        }

        public Builder upstreamProxy(InetSocketAddress address) {
            this.upstreamProxyProvider = () -> address;
            return this;
        }

        public Builder upstreamProxy(Supplier<InetSocketAddress> val) {
            this.upstreamProxyProvider = (Supplier)Preconditions.checkNotNull(val);
            return this;
        }

        public Builder harPostProcessor(HarPostProcessor harPostProcessor) {
            this.harPostProcessors.add(harPostProcessor);
            return this;
        }

        public TrafficCollector build() {
            return new TrafficCollector(this);
        }
    }
}

