/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.github.mike10004.seleniumhelp.BrAwareServerResponseCaptureFilter;
import com.github.mike10004.seleniumhelp.HarInteractions;
import com.github.mike10004.seleniumhelp.ImmutableHttpRequest;
import com.github.mike10004.seleniumhelp.TrafficMonitor;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import net.lightbody.bmp.core.har.HarNameValuePair;
import net.lightbody.bmp.core.har.HarPostData;
import net.lightbody.bmp.core.har.HarPostDataParam;
import net.lightbody.bmp.core.har.HarRequest;
import net.lightbody.bmp.core.har.HarResponse;
import net.lightbody.bmp.exception.UnsupportedCharsetException;
import net.lightbody.bmp.filters.ClientRequestCaptureFilter;
import net.lightbody.bmp.filters.HarCaptureFilter;
import net.lightbody.bmp.filters.HttpsAwareFiltersAdapter;
import net.lightbody.bmp.filters.ResolvedHostnameCacheFilter;
import net.lightbody.bmp.filters.ServerResponseCaptureFilter;
import net.lightbody.bmp.filters.util.HarCaptureUtil;
import net.lightbody.bmp.util.BrowserMobHttpUtil;
import org.littleshoot.proxy.impl.ProxyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrafficMonitorFilter
extends HttpsAwareFiltersAdapter {
    private static final Logger log = LoggerFactory.getLogger(TrafficMonitorFilter.class);
    private final TrafficMonitor trafficMonitor;
    private final transient Object notificationLock = new Object();
    private volatile boolean notifiedResponse;
    private final HarRequest harRequest = new HarRequest();
    private final HarResponse normalHarResponse = TrafficMonitorFilter._createDefaultResponse();
    private final ClientRequestCaptureFilter requestCaptureFilter;
    private final ServerResponseCaptureFilter responseCaptureFilter;
    private volatile HttpRequest capturedOriginalRequest;
    private volatile boolean addressResolved = false;
    private String serverIpAddress;

    public TrafficMonitorFilter(HttpRequest originalRequest, ChannelHandlerContext ctx, TrafficMonitor trafficMonitor) {
        super(originalRequest, ctx);
        HarCaptureFilter.class.getName();
        if (ProxyUtils.isCONNECT((HttpObject)originalRequest)) {
            throw new IllegalArgumentException("Attempted traffic listener capture for HTTP CONNECT request");
        }
        this.requestCaptureFilter = new ClientRequestCaptureFilter(originalRequest);
        this.responseCaptureFilter = new BrAwareServerResponseCaptureFilter(originalRequest, true);
        this.trafficMonitor = (TrafficMonitor)Preconditions.checkNotNull((Object)trafficMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResponseNotification(HarResponse harResponse) {
        Object object = this.notificationLock;
        synchronized (object) {
            if (this.notifiedResponse) {
                log.warn("already sent response notification; this will be suppressed: {}", (Object)harResponse);
                return;
            }
            ImmutableHttpRequest frozenRequest = HarInteractions.freeze(this.harRequest);
            this.trafficMonitor.responseReceived(frozenRequest, HarInteractions.freeze(harResponse));
            this.notifiedResponse = true;
        }
    }

    private static HarResponse _createDefaultResponse() {
        HarResponse defaultHarResponse = HarCaptureUtil.createHarResponseForFailure();
        defaultHarResponse.setError(HarCaptureUtil.getNoResponseReceivedErrorMessage());
        return defaultHarResponse;
    }

    public HttpResponse clientToProxyRequest(HttpObject httpObject) {
        this.requestCaptureFilter.clientToProxyRequest(httpObject);
        if (httpObject instanceof HttpRequest) {
            HttpRequest httpRequest;
            this.capturedOriginalRequest = httpRequest = (HttpRequest)httpObject;
            this.populateHarRequestFromHttpRequest(httpRequest, this.harRequest);
            this.captureQueryParameters(httpRequest, this.harRequest);
            this.captureRequestHeaders(httpRequest, this.harRequest);
        }
        if (httpObject instanceof LastHttpContent) {
            LastHttpContent lastHttpContent = (LastHttpContent)httpObject;
            this.captureTrailingHeaders(lastHttpContent, this.harRequest);
            this.captureRequestContent(this.requestCaptureFilter.getHttpRequest(), this.requestCaptureFilter.getFullRequestContents(), this.harRequest);
        }
        return null;
    }

    public HttpObject serverToProxyResponse(HttpObject httpObject) {
        this.responseCaptureFilter.serverToProxyResponse(httpObject);
        if (httpObject instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)httpObject;
            this.captureResponse(httpResponse, this.normalHarResponse);
        }
        if (httpObject instanceof LastHttpContent) {
            this.captureResponseContent(this.responseCaptureFilter.getHttpResponse(), this.responseCaptureFilter.getFullResponseContents(), this.normalHarResponse);
            this.sendResponseNotification(this.normalHarResponse);
        }
        return super.serverToProxyResponse(httpObject);
    }

    private void populateHarRequestFromHttpRequest(HttpRequest httpRequest, HarRequest harRequest) {
        harRequest.setMethod(httpRequest.getMethod().toString());
        harRequest.setUrl(this.getFullUrl(httpRequest));
        harRequest.setHttpVersion(httpRequest.getProtocolVersion().text());
    }

    protected void captureQueryParameters(HttpRequest httpRequest, HarRequest harRequest) {
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(httpRequest.getUri(), StandardCharsets.UTF_8);
        try {
            for (Map.Entry entry : queryStringDecoder.parameters().entrySet()) {
                for (String value : (List)entry.getValue()) {
                    harRequest.getQueryString().add(new HarNameValuePair((String)entry.getKey(), value));
                }
            }
        }
        catch (IllegalArgumentException e) {
            log.info("Unable to decode query parameters on URI: " + httpRequest.getUri(), (Throwable)e);
        }
    }

    protected void captureRequestHeaders(HttpRequest httpRequest, HarRequest harRequest) {
        HttpHeaders headers = httpRequest.headers();
        this.captureHeaders(headers, harRequest);
    }

    protected void captureTrailingHeaders(LastHttpContent lastHttpContent, HarRequest harRequest) {
        HttpHeaders headers = lastHttpContent.trailingHeaders();
        this.captureHeaders(headers, harRequest);
    }

    protected void captureHeaders(HttpHeaders headers, HarRequest harRequest) {
        for (Map.Entry header : headers.entries()) {
            harRequest.getHeaders().add(new HarNameValuePair((String)header.getKey(), (String)header.getValue()));
        }
    }

    protected void captureRequestContent(HttpRequest httpRequest, byte[] fullMessage, HarRequest harRequest) {
        Charset charset;
        if (fullMessage.length == 0) {
            return;
        }
        String contentType = HttpHeaders.getHeader((HttpMessage)httpRequest, (String)"Content-Type");
        if (contentType == null) {
            log.warn("No content type specified in request to {}. Content will be treated as {}", (Object)httpRequest.getUri(), (Object)"application/octet-stream");
            contentType = "application/octet-stream";
        }
        HarPostData postData = new HarPostData();
        harRequest.setPostData(postData);
        postData.setMimeType(contentType);
        boolean urlEncoded = contentType.startsWith("application/x-www-form-urlencoded");
        try {
            charset = BrowserMobHttpUtil.readCharsetInContentTypeHeader((String)contentType);
        }
        catch (UnsupportedCharsetException e) {
            log.warn("Found unsupported character set in Content-Type header '{}' in HTTP request to {}. Content will not be captured in HAR.", new Object[]{contentType, httpRequest.getUri(), e});
            return;
        }
        if (charset == null) {
            charset = BrowserMobHttpUtil.DEFAULT_HTTP_CHARSET;
            log.debug("No charset specified; using charset {} to decode contents to {}", (Object)charset, (Object)httpRequest.getUri());
        }
        if (urlEncoded) {
            String textContents = BrowserMobHttpUtil.getContentAsString((byte[])fullMessage, (Charset)charset);
            QueryStringDecoder queryStringDecoder = new QueryStringDecoder(textContents, charset, false);
            ImmutableList.Builder paramBuilder = ImmutableList.builder();
            for (Map.Entry entry : queryStringDecoder.parameters().entrySet()) {
                for (String value : (List)entry.getValue()) {
                    paramBuilder.add((Object)new HarPostDataParam((String)entry.getKey(), value));
                }
            }
            harRequest.getPostData().setParams((List)paramBuilder.build());
        } else {
            String postBody = BrowserMobHttpUtil.getContentAsString((byte[])fullMessage, (Charset)charset);
            harRequest.getPostData().setText(postBody);
        }
    }

    protected void captureResponseContent(HttpResponse httpResponse, byte[] fullMessage, HarResponse harResponse) {
        Charset charset;
        boolean forceBinary = false;
        String contentType = HttpHeaders.getHeader((HttpMessage)httpResponse, (String)"Content-Type");
        if (contentType == null) {
            log.warn("No content type specified in response from {}. Content will be treated as {}", (Object)this.originalRequest.getUri(), (Object)"application/octet-stream");
            contentType = "application/octet-stream";
        }
        if (this.responseCaptureFilter.isResponseCompressed() && !this.responseCaptureFilter.isDecompressionSuccessful()) {
            log.warn("Unable to decompress content with encoding: {}. Contents will be encoded as base64 binary data.", (Object)this.responseCaptureFilter.getContentEncoding());
            forceBinary = true;
        }
        try {
            charset = BrowserMobHttpUtil.readCharsetInContentTypeHeader((String)contentType);
        }
        catch (UnsupportedCharsetException e) {
            log.warn("Found unsupported character set in Content-Type header '{}' in HTTP response from {}. Content will not be captured in HAR.", new Object[]{contentType, this.originalRequest.getUri(), e});
            return;
        }
        if (charset == null) {
            charset = BrowserMobHttpUtil.DEFAULT_HTTP_CHARSET;
            log.debug("No charset specified; using charset {} to decode contents from {}", (Object)charset, (Object)this.originalRequest.getUri());
        }
        if (!forceBinary && BrowserMobHttpUtil.hasTextualContent((String)contentType)) {
            String text = BrowserMobHttpUtil.getContentAsString((byte[])fullMessage, (Charset)charset);
            harResponse.getContent().setText(text);
        } else {
            harResponse.getContent().setText(DatatypeConverter.printBase64Binary((byte[])fullMessage));
            harResponse.getContent().setEncoding("base64");
        }
        harResponse.getContent().setSize((long)fullMessage.length);
    }

    protected void captureResponse(HttpResponse httpResponse, HarResponse harResponse) {
        harResponse.setStatus(httpResponse.getStatus().code());
        harResponse.setStatusText(httpResponse.getStatus().reasonPhrase());
        harResponse.setHttpVersion(httpResponse.getProtocolVersion().text());
        this.captureResponseHeaderSize(httpResponse, harResponse);
        this.captureResponseMimeType(httpResponse, harResponse);
        this.captureResponseHeaders(httpResponse, harResponse);
        if (BrowserMobHttpUtil.isRedirect((HttpResponse)httpResponse)) {
            this.captureRedirectUrl(httpResponse, harResponse);
        }
    }

    protected void captureResponseMimeType(HttpResponse httpResponse, HarResponse harResponse) {
        String contentType = HttpHeaders.getHeader((HttpMessage)httpResponse, (String)"Content-Type");
        if (contentType != null) {
            harResponse.getContent().setMimeType(contentType);
        }
    }

    protected void captureResponseHeaderSize(HttpResponse httpResponse, HarResponse harResponse) {
        String statusLine = httpResponse.getProtocolVersion().toString() + ' ' + httpResponse.getStatus().toString();
        long responseHeadersSize = statusLine.length() + 6;
        HttpHeaders headers = httpResponse.headers();
        harResponse.setHeadersSize(responseHeadersSize += BrowserMobHttpUtil.getHeaderSize((HttpHeaders)headers));
    }

    protected void captureResponseHeaders(HttpResponse httpResponse, HarResponse harResponse) {
        HttpHeaders headers = httpResponse.headers();
        for (Map.Entry header : headers.entries()) {
            harResponse.getHeaders().add(new HarNameValuePair((String)header.getKey(), (String)header.getValue()));
        }
    }

    protected void captureRedirectUrl(HttpResponse httpResponse, HarResponse harResponse) {
        String locationHeaderValue = HttpHeaders.getHeader((HttpMessage)httpResponse, (String)"Location");
        if (locationHeaderValue != null) {
            harResponse.setRedirectURL(locationHeaderValue);
        }
    }

    protected void populateAddressFromCache(HttpRequest httpRequest) {
        String serverHost = this.getHost(httpRequest);
        if (serverHost != null && !serverHost.isEmpty()) {
            String resolvedAddress = ResolvedHostnameCacheFilter.getPreviouslyResolvedAddressForHost((String)serverHost);
            if (resolvedAddress != null) {
                this.serverIpAddress = resolvedAddress;
            } else {
                log.trace("Unable to find cached IP address for host: {}. IP address in HAR entry will be blank.", (Object)serverHost);
            }
        } else {
            log.warn("Unable to identify host from request uri: {}", (Object)httpRequest.getUri());
        }
    }

    public void proxyToServerResolutionSucceeded(String serverHostAndPort, InetSocketAddress resolvedRemoteAddress) {
        InetAddress resolvedAddress = resolvedRemoteAddress.getAddress();
        if (resolvedAddress != null) {
            this.addressResolved = true;
            this.serverIpAddress = resolvedAddress.getHostAddress();
        }
    }

    public void proxyToServerRequestSending() {
        if (!this.addressResolved) {
            this.populateAddressFromCache(this.capturedOriginalRequest);
        }
    }

    public void proxyToServerResolutionFailed(String hostAndPort) {
        HarResponse response = HarCaptureUtil.createHarResponseForFailure();
        response.setError(HarCaptureUtil.getResolutionFailedErrorMessage((String)hostAndPort));
        this.sendResponseNotification(response);
    }

    public void proxyToServerConnectionFailed() {
        HarResponse response = HarCaptureUtil.createHarResponseForFailure();
        response.setError(HarCaptureUtil.getConnectionFailedErrorMessage());
        this.sendResponseNotification(response);
    }

    public void serverToProxyResponseTimedOut() {
        HarResponse response = HarCaptureUtil.createHarResponseForFailure();
        response.setError(HarCaptureUtil.getResponseTimedOutErrorMessage());
        this.sendResponseNotification(response);
    }
}

