/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.github.mike10004.seleniumhelp.Bys;
import com.github.mike10004.seleniumhelp.ChromeCookie;
import com.github.mike10004.seleniumhelp.DeserializableCookie;
import com.github.mike10004.seleniumhelp.EnvironmentWebDriverFactory;
import com.github.mike10004.xvfbselenium.WebDriverSupport;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.lightbody.bmp.BrowserMobProxy;
import net.lightbody.bmp.client.ClientUtil;
import net.lightbody.bmp.mitm.CertificateAndKeySource;
import org.apache.http.client.utils.URIBuilder;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChromeWebDriverFactory
extends EnvironmentWebDriverFactory {
    private final ChromeOptions chromeOptions;
    private final Capabilities capabilitiesOverrides;
    private final CookiePreparer cookiePreparer;
    private static final CookiePreparer cookielessPreparer = new CookiePreparer(){

        @Override
        public void supplementOptions(ChromeOptions options) {
        }

        @Override
        public void prepareCookies(ChromeDriver driver) {
        }
    };

    public ChromeWebDriverFactory(Map<String, String> environment, ChromeOptions chromeOptions, Capabilities capabilitiesOverrides) {
        this(environment, chromeOptions, capabilitiesOverrides, cookielessPreparer);
    }

    public ChromeWebDriverFactory(Map<String, String> environment, ChromeOptions chromeOptions, Capabilities capabilitiesOverrides, CookiePreparer cookiePreparer) {
        super(environment);
        this.chromeOptions = (ChromeOptions)Preconditions.checkNotNull((Object)chromeOptions);
        this.capabilitiesOverrides = (Capabilities)Preconditions.checkNotNull((Object)capabilitiesOverrides);
        this.cookiePreparer = (CookiePreparer)Preconditions.checkNotNull((Object)cookiePreparer);
    }

    public ChromeWebDriverFactory() {
        this((Map<String, String>)ImmutableMap.of(), new ChromeOptions(), (Capabilities)new DesiredCapabilities());
    }

    public ChromeWebDriverFactory(Supplier<Map<String, String>> environmentSupplier, ChromeOptions chromeOptions, Capabilities capabilitiesOverrides) {
        this(environmentSupplier, chromeOptions, capabilitiesOverrides, cookielessPreparer);
    }

    public ChromeWebDriverFactory(Supplier<Map<String, String>> environmentSupplier, ChromeOptions chromeOptions, Capabilities capabilitiesOverrides, CookiePreparer cookiePreparer) {
        super(environmentSupplier);
        this.chromeOptions = (ChromeOptions)Preconditions.checkNotNull((Object)chromeOptions);
        this.capabilitiesOverrides = (Capabilities)Preconditions.checkNotNull((Object)capabilitiesOverrides);
        this.cookiePreparer = (CookiePreparer)Preconditions.checkNotNull((Object)cookiePreparer);
    }

    @Override
    public WebDriver createWebDriver(BrowserMobProxy proxy, CertificateAndKeySource certificateAndKeySource) throws IOException {
        this.cookiePreparer.supplementOptions(this.chromeOptions);
        DesiredCapabilities capabilities = this.toCapabilities(this.chromeOptions);
        Proxy seleniumProxy = ClientUtil.createSeleniumProxy((BrowserMobProxy)proxy);
        capabilities.setCapability("proxy", (Object)seleniumProxy);
        capabilities.merge(this.capabilitiesOverrides);
        ChromeDriver driver = WebDriverSupport.chromeInEnvironment((Map)((Map)this.environmentSupplier.get())).create((Capabilities)capabilities);
        this.cookiePreparer.prepareCookies(driver);
        return driver;
    }

    protected DesiredCapabilities toCapabilities(ChromeOptions chromeOptions) {
        DesiredCapabilities capabilities = DesiredCapabilities.chrome();
        capabilities.setCapability("chromeOptions", (Object)chromeOptions);
        return capabilities;
    }

    public static CookiePreparer makeCookieImplanter(Path scratchDir, Supplier<? extends Collection<DeserializableCookie>> cookiesSupplier) {
        return new CookieImplanter(scratchDir, cookiesSupplier);
    }

    public static class ChromeCookieTransform {
        private static CharMatcher dotMatcher = CharMatcher.is((char)'.');
        private static CharMatcher slashMatcher = CharMatcher.is((char)'/');

        public ChromeCookie transform(DeserializableCookie input) {
            ChromeCookie output = new ChromeCookie();
            output.url = this.constructUrlFromDomain(input.getBestDomainProperty(), input.isHttpOnly(), input.getPath());
            output.name = input.getName();
            output.value = input.getValue();
            output.domain = input.getBestDomainProperty();
            output.path = input.getPath();
            output.expirationDate = (double)input.getExpiryDate().getTime() / 1000.0;
            output.secure = input.isSecure();
            output.httpOnly = input.isHttpOnly();
            output.sameSite = ChromeCookie.SameSiteStatus.no_restriction;
            return output;
        }

        protected String constructUrlFromDomain(String domain, boolean secure, String path) {
            domain = dotMatcher.trimLeadingFrom((CharSequence)domain);
            String scheme = secure ? "https" : "http";
            path = slashMatcher.trimLeadingFrom((CharSequence)path);
            return scheme + "://" + domain + "/" + path;
        }
    }

    static class CookieImplanter
    implements CookiePreparer {
        private static final Logger log = LoggerFactory.getLogger(CookieImplanter.class);
        private static final String COOKIE_IMPLANT_EXTENSION_ID = "njacaggbgbhpimllodfhihjndngkadjh";
        private static final String COOKIE_IMPLANT_EXTENSION_VERSION = "1.3";
        private static final String COOKIE_IMPLANT_EXTENSION_RESOURCE_PATH = "/chrome-cookie-implant/njacaggbgbhpimllodfhihjndngkadjh-1.3.crx";
        private final ByteSource cookieImplantCrxSource;
        private final Path scratchDir;
        private final Supplier<? extends Collection<DeserializableCookie>> cookiesSupplier;
        private final transient Gson gson = this.buildChromeCookieGson();
        private final transient ChromeCookieTransform chromeCookieTransform = new ChromeCookieTransform();
        private final int outputTimeoutSeconds = 10;

        public CookieImplanter(Path scratchDir, Supplier<? extends Collection<DeserializableCookie>> cookiesSupplier) {
            this(scratchDir, cookiesSupplier, Resources.asByteSource((URL)CookieImplanter.class.getResource(COOKIE_IMPLANT_EXTENSION_RESOURCE_PATH)));
        }

        public CookieImplanter(Path scratchDir, Supplier<? extends Collection<DeserializableCookie>> cookiesSupplier, ByteSource cookieImplantCrxSource) {
            this.cookieImplantCrxSource = (ByteSource)Preconditions.checkNotNull((Object)cookieImplantCrxSource);
            this.scratchDir = (Path)Preconditions.checkNotNull((Object)scratchDir);
            this.cookiesSupplier = (Supplier)Preconditions.checkNotNull(cookiesSupplier);
        }

        protected Gson buildChromeCookieGson() {
            return new GsonBuilder().addSerializationExclusionStrategy(new ExclusionStrategy(){

                public boolean shouldSkipField(FieldAttributes f) {
                    return false;
                }

                public boolean shouldSkipClass(Class<?> clazz) {
                    return false;
                }
            }).create();
        }

        @Override
        public void supplementOptions(ChromeOptions options) throws IOException {
            File crxFile = File.createTempFile("chrome-cookie-implant", ".crx", this.scratchDir.toFile());
            this.cookieImplantCrxSource.copyTo(Files.asByteSink((File)crxFile, (FileWriteMode[])new FileWriteMode[0]));
            options.addExtensions(new File[]{crxFile});
        }

        @Override
        public void prepareCookies(ChromeDriver driver) throws WebDriverException {
            Collection<DeserializableCookie> inputCookies = this.cookiesSupplier.get();
            URI manageUrl = this.buildImplantUriFromCookies(inputCookies.stream());
            driver.get(manageUrl.toString());
            CookieImplantOutput output = this.waitForCookieImplantOutput((WebDriver)driver, 10);
            int numFailures = 0;
            for (CookieImplantOutput.CookieImplantResult result : output.imports) {
                if (result.success) continue;
                log.warn("cookie implant failed: {} {}", (Object)result.index, (Object)result.message);
                ++numFailures;
            }
            if (numFailures > 0) {
                throw new CookieImplantException(numFailures + " cookies failed to be implanted");
            }
            log.debug("{} cookies imported using implant extension", (Object)inputCookies.size());
            driver.get("data:,");
        }

        protected <T> By elementTextRepresentsObject(By elementLocator, Class<T> deserializedType, Predicate<? super T> predicate) {
            AtomicInteger pollCounter = new AtomicInteger(0);
            return Bys.elementWithText(elementLocator, (com.google.common.base.Predicate<String>)((com.google.common.base.Predicate)json -> {
                if (json == null) {
                    return false;
                }
                System.out.format("OUTPUT JSON %d%n", pollCounter.incrementAndGet());
                System.out.println((String)json);
                System.out.println();
                Object thing = this.gson.fromJson(json, deserializedType);
                return predicate.test(thing);
            }));
        }

        protected By byOutputStatus(Predicate<String> statusPredicate) {
            return this.elementTextRepresentsObject(By.cssSelector((String)"#output"), CookieImplantOutput.class, cio -> statusPredicate.test(cio.status));
        }

        protected CookieImplantOutput waitForCookieImplantOutput(WebDriver driver, int timeOutInSeconds) {
            WebElement outputElement = (WebElement)new WebDriverWait(driver, (long)timeOutInSeconds).until((Function)ExpectedConditions.presenceOfElementLocated((By)this.byOutputStatus("all_imports_processed"::equalsIgnoreCase)));
            String outputJson = outputElement.getText();
            CookieImplantOutput output = (CookieImplantOutput)this.gson.fromJson(outputJson, CookieImplantOutput.class);
            return output;
        }

        protected URI buildImplantUriFromCookies(Stream<DeserializableCookie> cookies) {
            return this.buildImplantUriFromCookieJsons(cookies.map(this.chromeCookieTransform::transform).map(arg_0 -> ((Gson)this.gson).toJson(arg_0)));
        }

        protected URI buildImplantUriFromCookieJsons(Stream<String> cookieJsons) {
            try {
                URIBuilder uriBuilder = new URIBuilder(URI.create("chrome-extension://njacaggbgbhpimllodfhihjndngkadjh/manage.html"));
                cookieJsons.forEach(cookieJson -> uriBuilder.addParameter("import", cookieJson));
                URI uri = uriBuilder.build();
                return uri;
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }

        protected static class CookieImplantException
        extends WebDriverException {
            public CookieImplantException() {
            }

            public CookieImplantException(String message) {
                super(message);
            }

            public CookieImplantException(Throwable cause) {
                super(cause);
            }

            public CookieImplantException(String message, Throwable cause) {
                super(message, cause);
            }
        }
    }

    public static class CookieImplantOutput {
        public String status;
        public List<CookieImplantResult> imports;

        public static class CookieImplantResult {
            public int index;
            public boolean success;
            public String message;
            public ChromeCookie savedCookie;
        }
    }

    public static interface CookiePreparer {
        public void supplementOptions(ChromeOptions var1) throws IOException;

        public void prepareCookies(ChromeDriver var1) throws WebDriverException;
    }
}

