/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.github.mike10004.seleniumhelp.DeserializableCookie;
import com.google.common.collect.Iterables;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.FormattedHeader;
import org.apache.http.Header;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.message.ParserCursor;
import org.apache.http.message.TokenParser;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

class CookieParser {
    private static final char PARAM_DELIMITER = ';';
    private static final char EQUAL_CHAR = '=';
    private static final BitSet TOKEN_DELIMS = TokenParser.INIT_BITSET((int[])new int[]{61, 59});
    private static final BitSet VALUE_DELIMS = TokenParser.INIT_BITSET((int[])new int[]{59});
    private final Map<String, CookieAttributeHandler> attribHandlerMap;
    private final TokenParser tokenParser = TokenParser.INSTANCE;

    public CookieParser(Iterable<CommonCookieAttributeHandler> handlers) {
        this.attribHandlerMap = new ConcurrentHashMap<String, CookieAttributeHandler>(Iterables.size(handlers));
        for (CommonCookieAttributeHandler handler : handlers) {
            this.attribHandlerMap.put(handler.getAttributeName().toLowerCase(Locale.ROOT), (CookieAttributeHandler)handler);
        }
    }

    static String getDefaultDomain(CookieOrigin origin) {
        return origin.getHost();
    }

    protected DeserializableCookie createCookie(CookieOrigin origin, String name, String value, Date creationDate) {
        DeserializableCookie c = new DeserializableCookie();
        c.setDomain(CookieParser.getDefaultDomain(origin));
        c.setPath(CookieParser.getDefaultPath(origin));
        c.setCreationDate(creationDate);
        c.setValue(value);
        c.setName(name);
        return c;
    }

    protected Date now() {
        return Calendar.getInstance().getTime();
    }

    public List<DeserializableCookie> parse(Header header, CookieOrigin origin) throws MalformedCookieException {
        ParserCursor cursor;
        CharArrayBuffer buffer;
        Args.notNull((Object)header, (String)"Header");
        Args.notNull((Object)origin, (String)"Cookie origin");
        if (!header.getName().equalsIgnoreCase("Set-Cookie")) {
            throw new MalformedCookieException("Unrecognized cookie header: '" + header.toString() + "'");
        }
        if (header instanceof FormattedHeader) {
            buffer = ((FormattedHeader)header).getBuffer();
            cursor = new ParserCursor(((FormattedHeader)header).getValuePos(), buffer.length());
        } else {
            String s = header.getValue();
            if (s == null) {
                throw new MalformedCookieException("Header value is null");
            }
            buffer = new CharArrayBuffer(s.length());
            buffer.append(s);
            cursor = new ParserCursor(0, buffer.length());
        }
        String name = this.tokenParser.parseToken(buffer, cursor, TOKEN_DELIMS);
        if (name.length() == 0) {
            return Collections.emptyList();
        }
        if (cursor.atEnd()) {
            return Collections.emptyList();
        }
        char valueDelim = buffer.charAt(cursor.getPos());
        cursor.updatePos(cursor.getPos() + 1);
        if (valueDelim != '=') {
            throw new MalformedCookieException("Cookie value is invalid: '" + header.toString() + "'");
        }
        String value = this.tokenParser.parseValue(buffer, cursor, VALUE_DELIMS);
        if (!cursor.atEnd()) {
            cursor.updatePos(cursor.getPos() + 1);
        }
        DeserializableCookie cookie = this.createCookie(origin, name, value, this.now());
        LinkedHashMap<String, String> attribMap = new LinkedHashMap<String, String>();
        while (!cursor.atEnd()) {
            String paramName = this.tokenParser.parseToken(buffer, cursor, TOKEN_DELIMS).toLowerCase(Locale.ROOT);
            String paramValue = null;
            if (!cursor.atEnd()) {
                char paramDelim = buffer.charAt(cursor.getPos());
                cursor.updatePos(cursor.getPos() + 1);
                if (paramDelim == '=') {
                    paramValue = this.tokenParser.parseToken(buffer, cursor, VALUE_DELIMS);
                    if (!cursor.atEnd()) {
                        cursor.updatePos(cursor.getPos() + 1);
                    }
                }
            }
            cookie.setAttribute(paramName, paramValue);
            attribMap.put(paramName, paramValue);
        }
        if (attribMap.containsKey("max-age")) {
            attribMap.remove("expires");
        }
        cookie.replaceAttributes(attribMap);
        for (Map.Entry entry : attribMap.entrySet()) {
            String paramName = ((String)entry.getKey()).toLowerCase(Locale.ROOT);
            String paramValue = (String)entry.getValue();
            CookieAttributeHandler handler = this.attribHandlerMap.get(paramName);
            if (handler == null) continue;
            handler.parse((SetCookie)cookie, paramValue);
        }
        return Collections.singletonList(cookie);
    }

    static String getDefaultPath(CookieOrigin origin) {
        String defaultPath = origin.getPath();
        int lastSlashIndex = defaultPath.lastIndexOf(47);
        if (lastSlashIndex >= 0) {
            if (lastSlashIndex == 0) {
                lastSlashIndex = 1;
            }
            defaultPath = defaultPath.substring(0, lastSlashIndex);
        }
        return defaultPath;
    }
}

