/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.cookie.SetCookie;
import org.apache.http.util.Args;

public class DeserializableCookie
implements ClientCookie,
SetCookie {
    static final String FIELD_ATTRIBUTES = "attribs";
    static final String FIELD_DOMAIN = "cookieDomain";
    static final String FIELD_HTTP_ONLY = "httpOnly";
    static final String FIELD_LAST_ACCESSED = "lastAccessed";
    static final String FIELD_CREATION_DATE = "creationDate";
    static final String FIELD_EXPIRY_DATE = "cookieExpiryDate";
    private String name;
    private final Map<String, String> attribs = new HashMap<String, String>();
    private String value;
    private String cookieComment;
    private String cookieDomain;
    private Date cookieExpiryDate;
    private String cookiePath;
    private boolean isSecure;
    private int cookieVersion;
    private Date creationDate;
    private Date lastAccessed;
    private boolean httpOnly;

    public String getAttribute(String name) {
        String value = this.attribs.get(name);
        if (value != null) {
            return value;
        }
        String casedKey = this.findAttributeKey(name);
        if (casedKey != null) {
            return this.attribs.get(casedKey);
        }
        return null;
    }

    public String setAttribute(String name, String value) {
        return this.attribs.put(name.toLowerCase(Locale.ROOT), value);
    }

    @Nullable
    protected String findAttributeKey(String name) {
        return this.attribs.keySet().stream().map(String::toLowerCase).filter(name::equalsIgnoreCase).findFirst().orElse(null);
    }

    public boolean containsAttribute(String name) {
        return this.attribs.containsKey(name) || this.findAttributeKey(name) != null;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getComment() {
        return this.cookieComment;
    }

    public String getCommentURL() {
        return null;
    }

    public Date getExpiryDate() {
        return this.cookieExpiryDate;
    }

    public boolean isPersistent() {
        return null != this.cookieExpiryDate;
    }

    public String getDomain() {
        return this.cookieDomain;
    }

    public String getPath() {
        return this.cookiePath;
    }

    public int[] getPorts() {
        return null;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public int getVersion() {
        return this.cookieVersion;
    }

    public boolean isExpired(Date now) {
        Args.notNull((Object)now, (String)"Date");
        Date cookieExpiryDate_ = this.cookieExpiryDate;
        return cookieExpiryDate_ != null && (cookieExpiryDate_.before(now) || this.cookieExpiryDate.equals(now));
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public Date getLastAccessed() {
        return this.lastAccessed;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setComment(String cookieComment) {
        this.cookieComment = cookieComment;
    }

    public void setDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    public void setExpiryDate(Date cookieExpiryDate) {
        this.cookieExpiryDate = cookieExpiryDate;
    }

    public void setPath(String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public void setSecure(boolean secure) {
        this.isSecure = secure;
    }

    public void setVersion(int cookieVersion) {
        this.cookieVersion = cookieVersion;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public void setLastAccessed(Date lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    public String getDomainAttribute() {
        return this.getAttribute("Domain");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeserializableCookie that = (DeserializableCookie)o;
        if (this.isSecure != that.isSecure) {
            return false;
        }
        if (this.httpOnly != that.httpOnly) {
            return false;
        }
        if (this.cookieVersion != that.cookieVersion) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.attribs != null ? !this.attribs.equals(that.attribs) : that.attribs != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        if (this.cookieComment != null ? !this.cookieComment.equals(that.cookieComment) : that.cookieComment != null) {
            return false;
        }
        if (this.cookieDomain != null ? !this.cookieDomain.equals(that.cookieDomain) : that.cookieDomain != null) {
            return false;
        }
        if (this.cookieExpiryDate != null ? !DeserializableCookie.equals(this.cookieExpiryDate, that.cookieExpiryDate) : that.cookieExpiryDate != null) {
            return false;
        }
        if (this.cookiePath != null ? !this.cookiePath.equals(that.cookiePath) : that.cookiePath != null) {
            return false;
        }
        if (this.creationDate != null ? !DeserializableCookie.equals(this.creationDate, that.creationDate) : that.creationDate != null) {
            return false;
        }
        return this.lastAccessed != null ? this.lastAccessed.equals(that.lastAccessed) : that.lastAccessed == null;
    }

    protected static boolean equals(Date a, Date b) {
        if (a == b) {
            return true;
        }
        if (a == null != (b == null)) {
            return false;
        }
        return DateUtils.truncatedEquals((Date)a, (Date)b, (int)13);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.attribs != null ? this.attribs.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.cookieComment != null ? this.cookieComment.hashCode() : 0);
        result = 31 * result + (this.cookieDomain != null ? this.cookieDomain.hashCode() : 0);
        result = 31 * result + (this.cookieExpiryDate != null ? this.cookieExpiryDate.hashCode() : 0);
        result = 31 * result + (this.cookiePath != null ? this.cookiePath.hashCode() : 0);
        result = 31 * result + (this.isSecure ? 1 : 0);
        result = 31 * result + (this.httpOnly ? 1 : 0);
        result = 31 * result + this.cookieVersion;
        result = 31 * result + (this.creationDate != null ? this.creationDate.hashCode() : 0);
        result = 31 * result + (this.lastAccessed != null ? this.lastAccessed.hashCode() : 0);
        return result;
    }

    public void replaceAttributes(Map<String, String> attribs) {
        this.attribs.clear();
        this.attribs.putAll(attribs);
    }

    public ImmutableMap<String, String> copyAttributes() {
        return ImmutableMap.copyOf(this.attribs);
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public String toString() {
        return "DeserializableCookie{name='" + this.name + '\'' + ", attribs=" + this.attribs + ", value='" + this.value + '\'' + ", cookieComment='" + this.cookieComment + '\'' + ", cookieDomain='" + this.cookieDomain + '\'' + ", cookieExpiryDate=" + this.cookieExpiryDate + ", cookiePath='" + this.cookiePath + '\'' + ", isSecure=" + this.isSecure + ", cookieVersion=" + this.cookieVersion + ", creationDate=" + this.creationDate + ", lastAccessed=" + this.lastAccessed + ", httpOnly=" + this.httpOnly + '}';
    }

    public String getBestDomainProperty() {
        String domainAttr = this.getDomainAttribute();
        if (domainAttr != null) {
            return domainAttr;
        }
        return this.getDomain();
    }
}

