/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.github.mike10004.seleniumhelp.WebDriverFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public abstract class EnvironmentWebDriverFactory
implements WebDriverFactory {
    protected final Supplier<Map<String, String>> environmentSupplier;

    public EnvironmentWebDriverFactory(Map<String, String> environment) {
        this(() -> ImmutableMap.copyOf((Map)environment));
    }

    public EnvironmentWebDriverFactory() {
        this(EnvironmentWebDriverFactory.createEnvironmentSupplierForDisplay(null));
    }

    public EnvironmentWebDriverFactory(Supplier<Map<String, String>> environmentSupplier) {
        this.environmentSupplier = (Supplier)Preconditions.checkNotNull(environmentSupplier, (Object)"environmentSupplier");
    }

    static Supplier<Map<String, String>> createEnvironmentSupplierForDisplay(@Nullable String display) {
        if (display == null) {
            return ImmutableMap::of;
        }
        return () -> ImmutableMap.of((Object)"DISPLAY", (Object)display);
    }
}

