/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.github.mike10004.seleniumhelp.DeserializableCookie;
import com.google.common.base.Converter;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.LinkedTreeMap;
import java.util.Date;
import java.util.Map;

public class ExplodedCookieConverter
extends Converter<Map<String, Object>, DeserializableCookie> {
    private static final Gson gson = new GsonBuilder().create();
    private static final ImmutableMap<String, String> impliedMissing = ImmutableMap.builder().put((Object)"cookieVersion", (Object)"0").put((Object)"cookieExpiryDate", (Object)"0").put((Object)"lastAccessed", (Object)"0").put((Object)"creationDate", (Object)"0").put((Object)"attribs", (Object)"{}").put((Object)"httpOnly", (Object)"false").build();

    protected DeserializableCookie doForward(Map<String, Object> intermediateRep) {
        JsonElement json = gson.toJsonTree(intermediateRep);
        DeserializableCookie cookie = (DeserializableCookie)gson.fromJson(json, DeserializableCookie.class);
        return cookie;
    }

    protected Map<String, Object> doBackward(DeserializableCookie cookie) {
        JsonObject json = gson.toJsonTree((Object)cookie).getAsJsonObject();
        this.removeDefaults(json);
        Map map = (Map)gson.fromJson((JsonElement)json, new TypeToken<LinkedTreeMap<String, Object>>(){}.getType());
        this.dateify(cookie, map);
        return map;
    }

    private void maybeDateify(Map<String, Object> map, String key, Date value) {
        if (value == null) {
            map.remove(key);
            return;
        }
        if (!map.containsKey(key)) {
            return;
        }
        map.put(key, value);
    }

    private void dateify(DeserializableCookie cookie, Map<String, Object> map) {
        this.maybeDateify(map, "lastAccessed", cookie.getLastAccessed());
        this.maybeDateify(map, "creationDate", cookie.getCreationDate());
        this.maybeDateify(map, "cookieExpiryDate", cookie.getExpiryDate());
    }

    private void removeDefaults(JsonObject object) {
        for (String name : impliedMissing.keySet()) {
            String jsonEncodingOfField;
            String jsonEncodingThatImpliesAbsence = (String)impliedMissing.get((Object)name);
            JsonElement element = object.get(name);
            if (element == null || !jsonEncodingThatImpliesAbsence.equals(jsonEncodingOfField = element.toString())) continue;
            object.remove(name);
        }
    }
}

