/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.github.mike10004.seleniumhelp.FirefoxCookieDb;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Converter;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.InternetDomainName;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;

public class FirefoxCookieRowTransform {
    private static final CharMatcher dot = CharMatcher.is((char)'.');
    @VisibleForTesting
    static Joiner.MapJoiner ATTRIB_JOINER = Joiner.on((char)';').withKeyValueSeparator('=');
    private static final ImmutableMap<String, Function<Map<String, Object>, Object>> _sqliteFieldToCookieValueGetterMap = ImmutableBiMap.builder().put((Object)"path", FirefoxCookieRowTransform.valueByKey("cookiePath")).put((Object)"expiry", FirefoxCookieRowTransform.valueByKey("cookieExpiryDate")).put((Object)"creationTime", FirefoxCookieRowTransform.valueByKey("creationDate")).put((Object)"originAttributes", FirefoxCookieRowTransform.valueByKey("attribs")).put((Object)"isHttpOnly", FirefoxCookieRowTransform.valueByKey("httpOnly")).put((Object)"baseDomain", map -> {
        String domain = (String)map.get("cookieDomain");
        if (domain != null) {
            if ("localhost".equals(domain = dot.trimLeadingFrom((CharSequence)domain))) {
                return "localhost";
            }
            try {
                InternetDomainName topPrivateDomain = InternetDomainName.from((String)domain).topPrivateDomain();
                return topPrivateDomain.toString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }).put((Object)"host", map -> {
        Map attrs = (Map)map.get("attribs");
        if (attrs != null) {
            Object value = attrs.entrySet().stream().filter(entry -> "domain".equalsIgnoreCase(entry.getKey().toString())).map(Map.Entry::getValue).findFirst().orElse(null);
            return value;
        }
        return null;
    }).build();
    private final Converter<Map<String, Object>, Map<String, String>> converter = new Converter<Map<String, Object>, Map<String, String>>(){

        protected Map<String, String> doForward(Map<String, Object> explodedCookie) {
            return FirefoxCookieRowTransform.this.apply(explodedCookie);
        }

        protected Map<String, Object> doBackward(Map<String, String> stringStringMap) {
            throw new UnsupportedOperationException("doBackward not supported");
        }
    };
    private static final int CREATED_EXPONENT = -3;
    private static final int LAST_ACCESSED_EXPONENT = -3;
    private static final int EXPIRY_EXPONENT = 3;

    private static Function<Map<String, Object>, Object> valueByKey(String key) {
        return map -> map.get(key);
    }

    public Function<Map<String, Object>, Map<String, String>> asFunction() {
        return arg_0 -> this.converter.convert(arg_0);
    }

    public Converter<Map<String, Object>, Map<String, String>> asConverter() {
        return this.converter;
    }

    protected Function<Map<String, Object>, Object> getCookieValueGetterBySqlFieldName(String sqlFieldName) {
        return (Function)_sqliteFieldToCookieValueGetterMap.getOrDefault((Object)sqlFieldName, map -> map.get(sqlFieldName));
    }

    public Map<String, String> apply(Map<String, Object> explodedCookie) {
        TreeMap<String, String> sqlRowMap = new TreeMap<String, String>();
        for (String sqlFieldName : FirefoxCookieDb.sqliteColumnNames) {
            sqlRowMap.put(sqlFieldName, "");
            Object value = this.getCookieValueGetterBySqlFieldName(sqlFieldName).apply(explodedCookie);
            if (value == null) continue;
            String valueStr = this.stringifyCookieValue(value, sqlFieldName);
            sqlRowMap.put(sqlFieldName, valueStr);
        }
        this.supplementSqlFields(explodedCookie, sqlRowMap);
        return sqlRowMap;
    }

    private static int getCookieToSqlDateConversionExponentBySqlFieldName(String sqlFieldName) {
        switch (sqlFieldName) {
            case "expiry": {
                return -3;
            }
            case "lastAccessed": {
                return 3;
            }
            case "creationTime": {
                return 3;
            }
        }
        throw new IllegalArgumentException("exponent unknown for " + sqlFieldName);
    }

    protected String stringifyCookieValue(Object cookieFieldValue, String sqlFieldName) {
        if (cookieFieldValue instanceof Map) {
            return ATTRIB_JOINER.join((Map)cookieFieldValue);
        }
        if (cookieFieldValue instanceof Date) {
            long value;
            BigInteger millis = BigInteger.valueOf(((Date)cookieFieldValue).getTime());
            int exponent = FirefoxCookieRowTransform.getCookieToSqlDateConversionExponentBySqlFieldName(sqlFieldName);
            if (exponent >= 0) {
                BigInteger factor = BigInteger.TEN.pow(exponent);
                value = millis.multiply(factor).longValueExact();
            } else {
                BigInteger denominator = BigInteger.TEN.pow(-exponent);
                value = millis.divide(denominator).longValueExact();
            }
            return String.valueOf(value);
        }
        if (cookieFieldValue instanceof Boolean) {
            return (Boolean)cookieFieldValue != false ? "1" : "0";
        }
        return cookieFieldValue.toString();
    }

    protected void supplementSqlFields(Map<String, Object> explodedCookie, Map<String, String> sqlRow) {
        if (!sqlRow.containsKey("isHttpOnly")) {
            sqlRow.put("isHttpOnly", "1");
        }
    }
}

