/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.github.mike10004.seleniumhelp.CookieParser;
import com.github.mike10004.seleniumhelp.CookieUtility;
import com.github.mike10004.seleniumhelp.DeserializableCookie;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.conn.util.InetAddressUtils;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.impl.cookie.BasicDomainHandler;
import org.apache.http.impl.cookie.BasicPathHandler;
import org.apache.http.impl.cookie.BasicSecureHandler;
import org.apache.http.impl.cookie.CookieSpecBase;
import org.apache.http.impl.cookie.DefaultCookieSpecProvider;
import org.apache.http.impl.cookie.LaxExpiresHandler;
import org.apache.http.impl.cookie.LaxMaxAgeHandler;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

class FlexibleCookieSpec
extends CookieSpecBase {
    private final CookieSpec delegate;
    private final CookieParser cookieParser;
    private static final CommonCookieAttributeHandler[] handlersArray = new CommonCookieAttributeHandler[]{new BasicPathHandler(), new BetterDomainHandler(), new LaxMaxAgeHandler(), new BasicSecureHandler(), new LaxExpiresHandler()};
    private static final ImmutableList<CommonCookieAttributeHandler> handlersList = ImmutableList.copyOf((Object[])handlersArray);

    public FlexibleCookieSpec(CookieSpec delegate) {
        this(delegate, handlersArray);
    }

    static ImmutableList<CommonCookieAttributeHandler> getDefaultAttributeHandlers() {
        return handlersList;
    }

    private FlexibleCookieSpec(CookieSpec delegate, CommonCookieAttributeHandler ... attributeHandlers) {
        super(attributeHandlers);
        this.delegate = (CookieSpec)Preconditions.checkNotNull((Object)delegate);
        this.cookieParser = new CookieParser(Arrays.asList(attributeHandlers));
    }

    public static FlexibleCookieSpec getDefault() {
        return new FlexibleCookieSpec(new DefaultCookieSpecProvider().create((HttpContext)new BasicHttpContext()));
    }

    public List<Cookie> parse(String setCookieHeaderValue, URL originUrl) throws MalformedCookieException {
        return this.parse(setCookieHeaderValue, CookieUtility.getInstance().buildCookieOrigin((URL)originUrl).origin);
    }

    public List<Cookie> parse(String setCookieHeaderValue, CookieOrigin origin) throws MalformedCookieException {
        BasicHeader header = new BasicHeader("Set-Cookie", setCookieHeaderValue);
        return this.parse((Header)header, origin);
    }

    public int getVersion() {
        return this.delegate.getVersion();
    }

    public List<Cookie> parse(Header header, CookieOrigin origin) throws MalformedCookieException {
        List<DeserializableCookie> cookies = this.cookieParser.parse(header, origin);
        return cookies.stream().map(x -> x).collect(Collectors.toList());
    }

    public List<Header> formatCookies(List<Cookie> cookies) {
        return this.delegate.formatCookies(cookies);
    }

    public Header getVersionHeader() {
        return this.delegate.getVersionHeader();
    }

    private static class BetterDomainHandler
    extends BasicDomainHandler {
        private BetterDomainHandler() {
        }

        public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        }

        static boolean domainMatch(String domain, String host) {
            String normalizedDomain;
            if (InetAddressUtils.isIPv4Address((String)host) || InetAddressUtils.isIPv6Address((String)host)) {
                return false;
            }
            String string = normalizedDomain = domain.startsWith(".") ? domain.substring(1) : domain;
            if (host.endsWith(normalizedDomain)) {
                int prefix = host.length() - normalizedDomain.length();
                if (prefix == 0) {
                    return true;
                }
                if (prefix > 1 && host.charAt(prefix - 1) == '.') {
                    return true;
                }
            }
            return false;
        }

        public boolean match(Cookie cookie, CookieOrigin origin) {
            Args.notNull((Object)cookie, (String)"Cookie");
            Args.notNull((Object)origin, (String)"Cookie origin");
            String host = origin.getHost();
            String domain = cookie.getDomain();
            if (domain == null) {
                return false;
            }
            if (domain.startsWith(".")) {
                domain = domain.substring(1);
            }
            if (host.equals(domain = domain.toLowerCase(Locale.ROOT))) {
                return true;
            }
            return BetterDomainHandler.domainMatch(domain, host);
        }
    }
}

