/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.github.mike10004.seleniumhelp.DeserializableCookie;
import com.github.mike10004.seleniumhelp.FlexibleCookieSpec;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.math.LongMath;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.lightbody.bmp.core.har.Har;
import net.lightbody.bmp.core.har.HarEntry;
import net.lightbody.bmp.core.har.HarNameValuePair;
import net.lightbody.bmp.core.har.HarRequest;
import net.lightbody.bmp.core.har.HarResponse;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.cookie.MalformedCookieException;

public class HarAnalysis {
    private final Har har;

    private HarAnalysis(Har har) {
        this.har = (Har)Preconditions.checkNotNull((Object)har);
    }

    public static HarAnalysis of(Har har) {
        return new HarAnalysis(har);
    }

    public List<DeserializableCookie> findCookies(FlexibleCookieSpec cookieSpec) {
        return this.findCookies(cookieSpec, HarEntry::getStartedDateTime);
    }

    public List<DeserializableCookie> findCookies(FlexibleCookieSpec cookieSpec, Function<HarEntry, Date> creationDateGetter) {
        Stream<HarEntry> headerValues = this.findEntriesWithSetCookieHeaders();
        ArrayList<DeserializableCookie> cookies = new ArrayList<DeserializableCookie>();
        headerValues.forEach(entry -> HarAnalysis.makeCookiesFromEntry(cookieSpec, entry).forEach(cookies::add));
        return cookies;
    }

    private static List<DeserializableCookie> makeCookiesFromEntry(FlexibleCookieSpec cookieSpec, HarEntry entry) {
        URL originUrl;
        Date requestDate = entry.getStartedDateTime();
        try {
            originUrl = new URL(entry.getRequest().getUrl());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        Stream<String> headerValues = entry.getResponse().getHeaders().stream().filter(header -> "Set-Cookie".equalsIgnoreCase(header.getName())).map(HarNameValuePair::getValue);
        ArrayList<DeserializableCookie> cookies = new ArrayList<DeserializableCookie>();
        headerValues.forEach(headerValue -> {
            System.out.format("Set-Cookie: %s%n", headerValue);
            try {
                Stream<DeserializableCookie> cookieStream = cookieSpec.parse((String)headerValue, originUrl).stream().map(x -> (DeserializableCookie)x);
                cookieStream.forEach(cookie -> {
                    cookie.setCreationDate(requestDate);
                    cookies.add((DeserializableCookie)cookie);
                });
            }
            catch (MalformedCookieException e) {
                throw new IllegalArgumentException(e);
            }
        });
        return cookies;
    }

    public Stream<HarEntry> findEntriesWithSetCookieHeaders() {
        Stream<HarEntry> entriesWithCookieHeaders = this.har.getLog().getEntries().stream().filter(HarAnalysis.entryPredicate(HarAnalysis.anyRequest(), input -> input != null && input.getHeaders().stream().anyMatch(hnvp -> "Set-Cookie".equalsIgnoreCase(hnvp.getName()))));
        return entriesWithCookieHeaders;
    }

    public Stream<Pair<HarRequest, Stream<String>>> findCookies() {
        Stream<HarEntry> entriesWithCookieHeaders = this.findEntriesWithSetCookieHeaders();
        Stream<Pair<HarRequest, HarResponse>> interactionsWithCookieHeaders = entriesWithCookieHeaders.map(HarAnalysis.entryToInteraction());
        Stream<Pair<HarRequest, Stream<String>>> mappedInteractions = interactionsWithCookieHeaders.map(HarAnalysis.rightTransform(HarAnalysis.responseHeaderTransform("Set-Cookie")));
        return mappedInteractions;
    }

    public static Function<HarResponse, Stream<String>> responseHeaderTransform(String requiredHeaderName) {
        Preconditions.checkNotNull((Object)requiredHeaderName);
        return input -> {
            Stream<HarNameValuePair> stream = input.getHeaders().stream().filter(harNameValuePair -> requiredHeaderName.equalsIgnoreCase(harNameValuePair.getName()));
            return stream.map(HarNameValuePair::getValue);
        };
    }

    private static <L, R> Predicate<Pair<L, R>> conjoinedPairPredicate(Predicate<? super L> leftPredicate, Predicate<? super R> rightPredicate) {
        return input -> input != null && leftPredicate.test((Object)input.getLeft()) && rightPredicate.test((Object)input.getRight());
    }

    public static Function<HarEntry, Pair<HarRequest, HarResponse>> entryToInteraction() {
        return input -> Pair.of((Object)input.getRequest(), (Object)input.getResponse());
    }

    public static Predicate<HarEntry> entryPredicate(Predicate<HarRequest> requestPredicate, Predicate<HarResponse> responsePredicate) {
        return harEntry -> harEntry != null && requestPredicate.test(harEntry.getRequest()) && responsePredicate.test(harEntry.getResponse());
    }

    public Stream<Pair<HarRequest, HarResponse>> asInteractions() {
        return this.har.getLog().getEntries().stream().map(HarAnalysis.entryToInteraction());
    }

    public Stream<Pair<HarRequest, HarResponse>> asInteractions(Predicate<HarRequest> requestPredicate, Predicate<HarResponse> responsePredicate) {
        return this.har.getLog().getEntries().stream().filter(HarAnalysis.entryPredicate(requestPredicate, responsePredicate)).map(HarAnalysis.entryToInteraction());
    }

    public static Predicate<HarRequest> anyRequest() {
        return harRequest -> true;
    }

    public static Predicate<HarResponse> anyResponse() {
        return harResponse -> true;
    }

    public static <L1, R1, L2, R2> Function<Pair<L1, R1>, Pair<L2, R2>> pairTransform(Function<L1, L2> left, Function<R1, R2> right) {
        return input -> Pair.of(left.apply(input.getLeft()), right.apply(input.getRight()));
    }

    public static <L, R1, R2> Function<Pair<L, R1>, Pair<L, R2>> rightTransform(Function<R1, R2> right) {
        return HarAnalysis.pairTransform(Function.identity(), right);
    }

    public static <L1, L2, R> Function<Pair<L1, R>, Pair<L2, R>> leftTransform(Function<L1, L2> left) {
        return HarAnalysis.pairTransform(left, Function.identity());
    }

    public static class CookieCollection {
        private final ImmutableMultimap<HarEntry, DeserializableCookie> cookiesByEntry;

        private CookieCollection(Multimap<HarEntry, DeserializableCookie> cookiesByEntry) {
            this.cookiesByEntry = ImmutableMultimap.copyOf(cookiesByEntry);
        }

        private static long getEntryResponseInstant(HarEntry entry) {
            return LongMath.checkedAdd((long)entry.getStartedDateTime().getTime(), (long)entry.getTime());
        }

        public static CookieCollection build(Stream<HarEntry> headerValues, FlexibleCookieSpec cookieSpec) {
            ImmutableMultimap.Builder m = ImmutableMultimap.builder();
            headerValues.forEach(entry -> {
                List cookies = HarAnalysis.makeCookiesFromEntry(cookieSpec, entry);
                m.putAll(entry, (Iterable)cookies);
            });
            return new CookieCollection((Multimap<HarEntry, DeserializableCookie>)m.build());
        }
    }
}

