/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.littleshoot.proxy.HttpFiltersAdapter;

public class HeaderModifyingRequestFilters
extends HttpFiltersAdapter {
    private final ImmutableSet<String> headersToRemove;
    private final ImmutableList<? extends Map.Entry<String, ?>> headersToReplace;
    private final ImmutableList<? extends Map.Entry<String, ?>> headersToAdd;

    public HeaderModifyingRequestFilters(HttpRequest originalRequest, Iterable<String> headersToRemove, Iterable<? extends Map.Entry<String, ?>> headersToReplace, Iterable<? extends Map.Entry<String, ?>> headersToAdd) {
        super(originalRequest);
        this.headersToRemove = ImmutableSet.copyOf(headersToRemove);
        this.headersToReplace = ImmutableList.copyOf(headersToReplace);
        this.headersToAdd = ImmutableList.copyOf(headersToAdd);
    }

    public static Builder builder() {
        return new Builder();
    }

    public HttpResponse proxyToServerRequest(HttpObject httpObject) {
        if (httpObject instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)httpObject;
            HttpHeaders headers = request.headers();
            this.customize(headers);
        }
        return null;
    }

    protected void customize(HttpHeaders headers) {
        for (String headerName : this.headersToRemove) {
            headers.remove(headerName);
        }
        for (Map.Entry header : this.headersToReplace) {
            headers.set((String)header.getKey(), header.getValue());
        }
        for (Map.Entry header : this.headersToAdd) {
            headers.add((String)header.getKey(), header.getValue());
        }
    }

    public static class Builder {
        private final Set<String> headersToRemove = new LinkedHashSet<String>();
        private final List<Map.Entry<String, ?>> headersToReplace = new ArrayList();
        private final List<Map.Entry<String, ?>> headersToAdd = new ArrayList();

        private Builder() {
        }

        public Builder add(String name, String value) {
            this.headersToAdd.add(new AbstractMap.SimpleImmutableEntry<Object, Object>(Preconditions.checkNotNull((Object)name, (Object)"name"), Preconditions.checkNotNull((Object)value, (Object)"value")));
            return this;
        }

        public Builder remove(String name) {
            this.headersToRemove.add((String)Preconditions.checkNotNull((Object)name, (Object)"name"));
            return this;
        }

        public Builder set(String name, String value) {
            this.headersToReplace.add(new AbstractMap.SimpleImmutableEntry<Object, Object>(Preconditions.checkNotNull((Object)name, (Object)"name"), Preconditions.checkNotNull((Object)value, (Object)"value")));
            return this;
        }

        public HeaderModifyingRequestFilters build(HttpRequest originalRequest) {
            return new HeaderModifyingRequestFilters(originalRequest, this.headersToRemove, this.headersToReplace, this.headersToAdd);
        }
    }
}

