/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.github.mike10004.seleniumhelp.ImmutableHttpHeaders;
import com.google.common.base.Preconditions;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import java.util.function.Supplier;

public class ImmutableHttpRequest
implements HttpRequest {
    private final HttpRequest inner;
    private final Supplier<HttpHeaders> headersSupplier;

    public ImmutableHttpRequest(HttpRequest inner) {
        this.inner = (HttpRequest)Preconditions.checkNotNull((Object)inner);
        this.headersSupplier = ImmutableHttpHeaders.memoize((HttpMessage)inner);
    }

    public HttpRequest setMethod(HttpMethod method) {
        throw new UnsupportedOperationException("immutable");
    }

    public HttpRequest setUri(String uri) {
        throw new UnsupportedOperationException("immutable");
    }

    public HttpRequest setProtocolVersion(HttpVersion version) {
        throw new UnsupportedOperationException("immutable");
    }

    public HttpHeaders headers() {
        return this.headersSupplier.get();
    }

    public void setDecoderResult(DecoderResult result) {
        throw new UnsupportedOperationException("immutable");
    }

    public HttpMethod getMethod() {
        return this.inner.getMethod();
    }

    public String getUri() {
        return this.inner.getUri();
    }

    public HttpVersion getProtocolVersion() {
        return this.inner.getProtocolVersion();
    }

    public DecoderResult getDecoderResult() {
        return this.inner.getDecoderResult();
    }

    public String toString() {
        return this.inner.toString();
    }
}

