/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.github.mike10004.seleniumhelp.ImmutableHttpHeaders;
import com.google.common.base.Preconditions;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.util.function.Supplier;

public class ImmutableHttpResponse
implements HttpResponse {
    private final HttpResponse inner;
    private final Supplier<HttpHeaders> headersSupplier;

    public ImmutableHttpResponse(HttpResponse inner) {
        this.inner = (HttpResponse)Preconditions.checkNotNull((Object)inner);
        this.headersSupplier = ImmutableHttpHeaders.memoize((HttpMessage)inner);
    }

    public HttpResponseStatus getStatus() {
        return this.inner.getStatus();
    }

    public HttpResponse setStatus(HttpResponseStatus status) {
        throw new UnsupportedOperationException("immutable");
    }

    public HttpResponse setProtocolVersion(HttpVersion version) {
        throw new UnsupportedOperationException("immutable");
    }

    public HttpHeaders headers() {
        return this.headersSupplier.get();
    }

    public HttpVersion getProtocolVersion() {
        return this.inner.getProtocolVersion();
    }

    public DecoderResult getDecoderResult() {
        return this.inner.getDecoderResult();
    }

    public void setDecoderResult(DecoderResult result) {
        throw new UnsupportedOperationException("immutable");
    }

    public String toString() {
        return this.inner.toString();
    }
}

