/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.google.common.annotations.VisibleForTesting;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class JvmProxyDetector {
    @Nullable
    public InetSocketAddress detectJvmProxy() {
        return this.detectJvmProxy(System.getProperties());
    }

    @Nullable
    @VisibleForTesting
    protected InetSocketAddress detectJvmProxy(Properties sysprops) throws IllegalStateException, NumberFormatException {
        String httpProxyHost = sysprops.getProperty("http.proxyHost");
        String httpProxyPort = sysprops.getProperty("http.proxyPort");
        String httpsProxyHost = sysprops.getProperty("http.proxyHost");
        String httpsProxyPort = sysprops.getProperty("http.proxyPort");
        if (!Objects.equals(httpProxyHost, httpsProxyHost)) {
            throw new IllegalStateException("system properties define conflicting values for http.proxyHost=" + httpProxyHost + " and httpsProxyHost=" + httpsProxyHost);
        }
        if (!Objects.equals(httpProxyPort, httpsProxyPort)) {
            throw new IllegalStateException("system properties define conflicting values for http.proxyPort=" + httpProxyPort + " and httpsProxyPort=" + httpsProxyPort);
        }
        if (httpsProxyHost == null != (httpsProxyPort == null)) {
            throw new IllegalStateException("nullness of https.proxyHost=" + httpsProxyHost + " and https.proxyPort=" + httpsProxyPort + " system properties must be consistent");
        }
        if (httpsProxyHost != null) {
            return new InetSocketAddress(httpsProxyHost, Integer.parseInt(httpsProxyPort));
        }
        return null;
    }

    public Supplier<Optional<InetSocketAddress>> asOptionalSupplier() {
        return () -> Optional.ofNullable(this.detectJvmProxy());
    }
}

