/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.github.mike10004.seleniumhelp.MemorySecurityProviderTool;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.security.KeyStore;
import java.util.Arrays;
import net.lightbody.bmp.mitm.CertificateAndKey;
import net.lightbody.bmp.mitm.CertificateAndKeySource;
import net.lightbody.bmp.mitm.KeyStoreCertificateSource;
import net.lightbody.bmp.mitm.KeyStoreFileCertificateSource;
import net.lightbody.bmp.mitm.exception.CertificateSourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreStreamCertificateSource
implements CertificateAndKeySource {
    private static final Logger log = LoggerFactory.getLogger(KeyStoreFileCertificateSource.class);
    private final ByteSource keyStoreByteSource;
    private final String keyStoreType;
    private final String keyStorePassword;
    private final String privateKeyAlias;
    private final MemorySecurityProviderTool securityProviderTool;
    private final Supplier<CertificateAndKey> certificateAndKey = Suppliers.memoize(() -> this.loadKeyStore());

    public KeyStoreStreamCertificateSource(String keyStoreType, ByteSource keyStoreByteSource, String privateKeyAlias, String keyStorePassword) {
        this(keyStoreType, keyStoreByteSource, privateKeyAlias, keyStorePassword, new MemorySecurityProviderTool());
    }

    public KeyStoreStreamCertificateSource(String keyStoreType, ByteSource keyStoreByteSource, String privateKeyAlias, String keyStorePassword, MemorySecurityProviderTool securityProviderTool) {
        this.keyStoreType = (String)Preconditions.checkNotNull((Object)keyStoreType);
        this.keyStoreByteSource = (ByteSource)Preconditions.checkNotNull((Object)keyStoreByteSource);
        this.privateKeyAlias = (String)Preconditions.checkNotNull((Object)privateKeyAlias);
        this.keyStorePassword = keyStorePassword;
        this.securityProviderTool = (MemorySecurityProviderTool)((Object)Preconditions.checkNotNull((Object)((Object)securityProviderTool)));
    }

    public CertificateAndKey load() {
        return (CertificateAndKey)this.certificateAndKey.get();
    }

    private CertificateAndKey loadKeyStore() {
        byte[] keyStoreBytes;
        try {
            keyStoreBytes = this.keyStoreByteSource.read();
        }
        catch (IOException e) {
            throw new CertificateSourceException("Unable to open KeyStore byte source: " + this.keyStoreByteSource, (Throwable)e);
        }
        char[] keyStorePasswordChars = this.keyStorePassword.toCharArray();
        KeyStore keyStore = this.securityProviderTool.loadKeyStore(keyStoreBytes, this.keyStoreType, keyStorePasswordChars);
        Arrays.fill(keyStorePasswordChars, '\u0000');
        Arrays.fill(keyStoreBytes, (byte)0);
        KeyStoreCertificateSource keyStoreCertificateSource = new KeyStoreCertificateSource(keyStore, this.privateKeyAlias, this.keyStorePassword);
        return keyStoreCertificateSource.load();
    }
}

