/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import net.lightbody.bmp.mitm.exception.ImportException;
import net.lightbody.bmp.mitm.exception.KeyStoreAccessException;
import net.lightbody.bmp.mitm.tools.DefaultSecurityProviderTool;

public final class MemorySecurityProviderTool
extends DefaultSecurityProviderTool {
    public KeyStore loadKeyStore(File file, String keyStoreType, String password) {
        throw new UnsupportedOperationException("loading from file not supported by " + ((Object)((Object)this)).getClass());
    }

    public KeyStore loadKeyStore(byte[] bytes, String keyStoreType, char[] password) {
        KeyStore keyStore;
        Preconditions.checkNotNull((Object)bytes, (Object)"bytes");
        Preconditions.checkNotNull((Object)password, (Object)"password");
        try {
            keyStore = KeyStore.getInstance(keyStoreType);
        }
        catch (KeyStoreException e) {
            throw new KeyStoreAccessException("Unable to get KeyStore instance of type: " + keyStoreType, (Throwable)e);
        }
        try (ByteArrayInputStream keystoreAsStream = new ByteArrayInputStream(bytes);){
            keyStore.load(keystoreAsStream, password);
        }
        catch (IOException e) {
            throw new ImportException("Unable to read KeyStore from byte array of length " + bytes.length, (Throwable)e);
        }
        catch (NoSuchAlgorithmException | CertificateException e) {
            throw new ImportException("Error while reading KeyStore", (Throwable)e);
        }
        return keyStore;
    }
}

