/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.seleniumhelp;

import com.github.mike10004.seleniumhelp.HarPlus;
import com.github.mike10004.seleniumhelp.ImmutableHttpRequest;
import com.github.mike10004.seleniumhelp.ImmutableHttpResponse;
import com.github.mike10004.seleniumhelp.TrafficGenerator;
import com.github.mike10004.seleniumhelp.TrafficListener;
import com.github.mike10004.seleniumhelp.WebDriverFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.lightbody.bmp.BrowserMobProxy;
import net.lightbody.bmp.BrowserMobProxyServer;
import net.lightbody.bmp.core.har.Har;
import net.lightbody.bmp.filters.HttpsAwareFiltersAdapter;
import net.lightbody.bmp.mitm.CertificateAndKeySource;
import net.lightbody.bmp.mitm.manager.ImpersonatingMitmManager;
import net.lightbody.bmp.proxy.CaptureType;
import org.littleshoot.proxy.HttpFilters;
import org.littleshoot.proxy.HttpFiltersSource;
import org.littleshoot.proxy.HttpFiltersSourceAdapter;
import org.littleshoot.proxy.MitmManager;
import org.littleshoot.proxy.impl.ProxyUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;

public class TrafficCollector {
    private final WebDriverFactory webDriverFactory;
    private final CertificateAndKeySource certificateAndKeySource;
    private final ImmutableList<HttpFiltersSource> httpFiltersSources;
    private final java.util.function.Supplier<Optional<InetSocketAddress>> upstreamProxyProvider;

    public TrafficCollector(WebDriverFactory webDriverFactory, CertificateAndKeySource certificateAndKeySource, HttpFiltersSource httpFiltersSource, java.util.function.Supplier<Optional<InetSocketAddress>> upstreamProxyProvider) {
        this(webDriverFactory, certificateAndKeySource, (Iterable<? extends HttpFiltersSource>)ImmutableList.of((Object)httpFiltersSource), upstreamProxyProvider);
    }

    public TrafficCollector(WebDriverFactory webDriverFactory, CertificateAndKeySource certificateAndKeySource, Iterable<? extends HttpFiltersSource> httpFiltersSources, java.util.function.Supplier<Optional<InetSocketAddress>> upstreamProxyProvider) {
        this.webDriverFactory = (WebDriverFactory)Preconditions.checkNotNull((Object)webDriverFactory);
        this.certificateAndKeySource = (CertificateAndKeySource)Preconditions.checkNotNull((Object)certificateAndKeySource);
        this.httpFiltersSources = ImmutableList.copyOf(httpFiltersSources);
        this.upstreamProxyProvider = (java.util.function.Supplier)Preconditions.checkNotNull(upstreamProxyProvider);
    }

    @Deprecated
    public TrafficCollector(WebDriverFactory webDriverFactory, CertificateAndKeySource certificateAndKeySource, Iterable<? extends HttpFiltersSource> httpFiltersSources, Supplier<com.google.common.base.Optional<InetSocketAddress>> upstreamProxyProvider) {
        this(webDriverFactory, certificateAndKeySource, httpFiltersSources, TrafficCollector.guavaToJava(upstreamProxyProvider));
    }

    private static <T> java.util.function.Supplier<Optional<T>> guavaToJava(Supplier<com.google.common.base.Optional<T>> supplier) {
        return () -> Optional.ofNullable(((com.google.common.base.Optional)supplier.get()).orNull());
    }

    protected Set<CaptureType> getCaptureTypes() {
        return EnumSet.allOf(CaptureType.class);
    }

    protected static java.util.function.Supplier<Optional<InetSocketAddress>> absentUpstreamProxyProvider() {
        return Optional::empty;
    }

    public <R> HarPlus<R> collect(TrafficGenerator<R> generator) throws IOException, WebDriverException {
        return this.collect(generator, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> HarPlus<R> collect(TrafficGenerator<R> generator, @Nullable TrafficListener listener) throws IOException, WebDriverException {
        R result;
        Preconditions.checkNotNull(generator, (Object)"generator");
        BrowserMobProxy bmp = this.createProxy(this.certificateAndKeySource);
        bmp.enableHarCaptureTypes(this.getCaptureTypes());
        bmp.newHar();
        if (listener != null) {
            this.addResponseNotificationFilters(bmp, listener);
        }
        bmp.start();
        try {
            WebDriver driver = this.webDriverFactory.createWebDriver(bmp, this.certificateAndKeySource);
            try {
                result = generator.generate(driver);
            }
            finally {
                driver.quit();
            }
        }
        finally {
            bmp.stop();
        }
        Har har = bmp.getHar();
        return new HarPlus<R>(har, result);
    }

    protected void addResponseNotificationFilters(BrowserMobProxy bmp, final TrafficListener listener) {
        Preconditions.checkNotNull((Object)listener, (Object)"listener");
        bmp.addLastHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                if (!ProxyUtils.isCONNECT((HttpObject)originalRequest)) {
                    return new ResponseNotificationFilter(originalRequest, ctx, listener);
                }
                return null;
            }
        });
    }

    protected MitmManager createMitmManager(BrowserMobProxy proxy, CertificateAndKeySource certificateAndKeySource) {
        ImpersonatingMitmManager mitmManager = ImpersonatingMitmManager.builder().rootCertificateSource(certificateAndKeySource).build();
        return mitmManager;
    }

    protected BrowserMobProxy createProxy(CertificateAndKeySource certificateAndKeySource) {
        BrowserMobProxyServer bmp = new BrowserMobProxyServer();
        MitmManager mitmManager = this.createMitmManager((BrowserMobProxy)bmp, certificateAndKeySource);
        bmp.setMitmManager(mitmManager);
        this.httpFiltersSources.forEach(arg_0 -> ((BrowserMobProxy)bmp).addLastHttpFilterFactory(arg_0));
        InetSocketAddress upstreamProxy = this.upstreamProxyProvider.get().orElse(null);
        if (upstreamProxy != null) {
            bmp.setChainedProxy(upstreamProxy);
        }
        return bmp;
    }

    protected static class ResponseNotificationFilter
    extends HttpsAwareFiltersAdapter {
        private final TrafficListener trafficListener;

        public ResponseNotificationFilter(HttpRequest originalRequest, ChannelHandlerContext ctx, TrafficListener trafficListener) {
            super(originalRequest, ctx);
            this.trafficListener = (TrafficListener)Preconditions.checkNotNull((Object)trafficListener);
        }

        public HttpObject serverToProxyResponse(HttpObject httpObject) {
            if (httpObject instanceof HttpResponse) {
                this.trafficListener.responseReceived(new ImmutableHttpResponse((HttpResponse)httpObject));
            }
            return httpObject;
        }

        public HttpResponse proxyToServerRequest(HttpObject httpObject) {
            if (httpObject instanceof HttpRequest) {
                this.trafficListener.sendingRequest(new ImmutableHttpRequest((HttpRequest)httpObject));
            }
            return null;
        }
    }
}

