/*
 * Decompiled with CFR 0.152.
 */
package com.github.mike10004.xvfbselenium;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.remote.DesiredCapabilities;

public class WebDriverSupport {
    private WebDriverSupport() {
    }

    public static ChromeInCustomEnvironment chromeOnDisplay(String display) {
        return WebDriverSupport.chromeInEnvironment(WebDriverSupport.createEnvironmentWithDisplay(display));
    }

    public static ChromeInCustomEnvironment chromeInEnvironment(Map<String, String> environment) {
        return new ChromeInCustomEnvironment(environment);
    }

    public static FirefoxInCustomEnvironment firefoxInEnvironment(Map<String, String> environment) {
        return new FirefoxInCustomEnvironment(environment);
    }

    private static ImmutableMap<String, String> createEnvironmentWithDisplay(String display) {
        return ImmutableMap.of((Object)"DISPLAY", (Object)Preconditions.checkNotNull((Object)display, (Object)"display must be non-null, e.g. \":1\""));
    }

    public static FirefoxInCustomEnvironment firefoxOnDisplay(String display) {
        return WebDriverSupport.firefoxInEnvironment(WebDriverSupport.createEnvironmentWithDisplay(display));
    }

    public static class ChromeInCustomEnvironment {
        private final Map<String, String> environment;

        private ChromeInCustomEnvironment(Map<String, String> environment) {
            this.environment = ImmutableMap.copyOf(environment);
        }

        public ChromeDriver create() {
            return this.create(this.createEnvironmentlessDriverServiceBuilder());
        }

        public ChromeDriver create(ChromeDriverService.Builder builder) {
            return new ChromeDriver(this.buildService(builder));
        }

        public ChromeDriver create(Capabilities capabilities) {
            return this.create(this.createEnvironmentlessDriverServiceBuilder(), capabilities);
        }

        public ChromeDriver create(ChromeOptions options) {
            return this.create(this.createEnvironmentlessDriverServiceBuilder(), options);
        }

        public ChromeDriver create(ChromeDriverService.Builder builder, ChromeOptions options) {
            return new ChromeDriver(this.buildService(builder), options);
        }

        public ChromeDriver create(ChromeDriverService.Builder builder, Capabilities capabilities) {
            return new ChromeDriver(this.buildService(builder), capabilities);
        }

        protected ChromeDriverService buildService(ChromeDriverService.Builder builder) {
            builder.withEnvironment(this.environment);
            return (ChromeDriverService)builder.build();
        }

        protected ChromeDriverService.Builder createEnvironmentlessDriverServiceBuilder() {
            ChromeDriverService.Builder builder = (ChromeDriverService.Builder)new ChromeDriverService.Builder().usingAnyFreePort();
            return builder;
        }
    }

    public static class FirefoxInCustomEnvironment {
        private final Map<String, String> environment;

        public FirefoxInCustomEnvironment(Map<String, String> environment) {
            this.environment = (Map)Preconditions.checkNotNull(environment);
        }

        public FirefoxDriver create() {
            return this.create(new FirefoxBinary(), new FirefoxProfile());
        }

        public FirefoxDriver create(FirefoxBinary binary, FirefoxProfile profile) {
            return this.create(binary, profile, (Capabilities)new DesiredCapabilities());
        }

        public FirefoxDriver create(Capabilities desiredCapabilities) {
            return this.create(new FirefoxBinary(), new FirefoxProfile(), desiredCapabilities);
        }

        public FirefoxDriver create(FirefoxBinary binary, FirefoxProfile profile, Capabilities desiredCapabilities) {
            for (String variableName : this.environment.keySet()) {
                binary.setEnvironmentProperty(variableName, this.environment.get(variableName));
            }
            GeckoDriverService driverService = FirefoxInCustomEnvironment.buildDriverService(binary);
            Capabilities desiredCapabilitiesWithProfileProperties = FirefoxProfiles.populateProfile(profile, desiredCapabilities);
            Capabilities requiredCapabilities = null;
            FirefoxDriver driver = new FirefoxDriver(driverService, desiredCapabilitiesWithProfileProperties, requiredCapabilities);
            return driver;
        }

        private static GeckoDriverService buildDriverService(FirefoxBinary binary) {
            Preconditions.checkNotNull((Object)binary, (Object)"binary");
            GeckoDriverService.Builder builder = new GeckoDriverService.Builder(binary);
            builder.withEnvironment(binary.getExtraEnv());
            builder.usingPort(0);
            return (GeckoDriverService)builder.build();
        }

        private static class FirefoxProfiles {
            private FirefoxProfiles() {
            }

            public static Capabilities populateProfile(FirefoxProfile profile, Capabilities capabilities) {
                Object rawOptions;
                Preconditions.checkNotNull((Object)profile, (Object)"profile");
                Preconditions.checkNotNull((Object)capabilities, (Object)"capabilities");
                if (capabilities.getCapability("webStorageEnabled") != null) {
                    Boolean supportsWebStorage = (Boolean)capabilities.getCapability("webStorageEnabled");
                    profile.setPreference("dom.storage.enabled", supportsWebStorage.booleanValue());
                }
                if (capabilities.getCapability("acceptSslCerts") != null) {
                    Boolean acceptCerts = (Boolean)capabilities.getCapability("acceptSslCerts");
                    profile.setAcceptUntrustedCertificates(acceptCerts.booleanValue());
                }
                if (capabilities.getCapability("loggingPrefs") != null) {
                    LoggingPreferences logsPrefs = (LoggingPreferences)capabilities.getCapability("loggingPrefs");
                    for (String logtype : logsPrefs.getEnabledLogTypes()) {
                        profile.setPreference("webdriver.log." + logtype, logsPrefs.getLevel(logtype).intValue());
                    }
                }
                if (capabilities.getCapability("nativeEvents") != null) {
                    Boolean nativeEventsEnabled = (Boolean)capabilities.getCapability("nativeEvents");
                    profile.setEnableNativeEvents(nativeEventsEnabled.booleanValue());
                }
                if ((rawOptions = capabilities.getCapability("moz:firefoxOptions")) == null) {
                    rawOptions = capabilities.getCapability("firefoxOptions");
                }
                if (rawOptions != null && !(rawOptions instanceof FirefoxOptions)) {
                    throw new WebDriverException("Firefox option was set, but is not a FirefoxOption: " + rawOptions);
                }
                FirefoxOptions options = (FirefoxOptions)rawOptions;
                if (options == null) {
                    options = new FirefoxOptions();
                }
                options.setProfile(profile);
                DesiredCapabilities toReturn = capabilities instanceof DesiredCapabilities ? (DesiredCapabilities)capabilities : new DesiredCapabilities(capabilities);
                toReturn.setCapability("firefoxOptions", (Object)options);
                toReturn.setCapability("moz:firefoxOptions", (Object)options);
                return toReturn;
            }
        }
    }
}

