/*
 * Decompiled with CFR 0.152.
 */
package play.utils;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import play.core.utils.AsciiBitSet;
import play.core.utils.AsciiSet;
import play.core.utils.AsciiSet$;
import play.core.utils.AsciiSet$Sets$;
import play.core.utils.AsciiUnion;
import play.utils.InvalidUriEncodingException;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class UriEncoding$ {
    public static final UriEncoding$ MODULE$;
    private final AsciiBitSet play$utils$UriEncoding$$segmentChars;

    static {
        new UriEncoding$();
    }

    public String encodePathSegment(String s, String inputCharset) {
        byte[] in = s.getBytes(inputCharset);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Predef$.MODULE$.byteArrayOps(in).foreach((Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final ByteArrayOutputStream out$1;

            public final void apply(byte b) {
                boolean allowed = UriEncoding$.MODULE$.play$utils$UriEncoding$$segmentChars().get(b & 0xFF);
                if (allowed) {
                    this.out$1.write(b);
                } else {
                    this.out$1.write(37);
                    this.out$1.write(UriEncoding$.MODULE$.play$utils$UriEncoding$$upperHex(b >> 4 & 0xF));
                    this.out$1.write(UriEncoding$.MODULE$.play$utils$UriEncoding$$upperHex(b & 0xF));
                }
            }
            {
                this.out$1 = out$1;
            }
        });
        return out.toString("US-ASCII");
    }

    public String encodePathSegment(String s, Charset inputCharset) {
        return this.encodePathSegment(s, inputCharset.name());
    }

    public String decodePathSegment(String s, String outputCharset) {
        byte[] in = s.getBytes("US-ASCII");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IntRef inPos = IntRef.create((int)0);
        while (inPos.elem < in.length) {
            int b = this.next$1(in, inPos);
            if (b == 37) {
                if (inPos.elem >= in.length) {
                    throw new InvalidUriEncodingException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot decode ", ": % at end of string"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s})));
                }
                int high = this.fromHex(this.next$1(in, inPos));
                if (high == -1) {
                    throw new InvalidUriEncodingException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot decode ", ": expected hex digit at position ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s, BoxesRunTime.boxToInteger((int)inPos.elem)})));
                }
                if (inPos.elem >= in.length) {
                    throw new InvalidUriEncodingException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot decode ", ": incomplete percent encoding at end of string"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s})));
                }
                int low = this.fromHex(this.next$1(in, inPos));
                if (low == -1) {
                    throw new InvalidUriEncodingException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot decode ", ": expected hex digit at position ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s, BoxesRunTime.boxToInteger((int)inPos.elem)})));
                }
                out.write((high << 4) + low);
                continue;
            }
            if (this.play$utils$UriEncoding$$segmentChars().get(b)) {
                out.write(b);
                continue;
            }
            throw new InvalidUriEncodingException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot decode ", ": illegal character at position ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s, BoxesRunTime.boxToInteger((int)inPos.elem)})));
        }
        return out.toString(outputCharset);
    }

    public String decodePathSegment(String s, Charset outputCharset) {
        return this.decodePathSegment(s, outputCharset.name());
    }

    public String decodePath(String s, String outputCharset) {
        return ((TraversableOnce)this.splitString(s, '/').map((Function1)new Serializable(outputCharset){
            public static final long serialVersionUID = 0L;
            private final String outputCharset$1;

            public final String apply(String x$1) {
                return UriEncoding$.MODULE$.decodePathSegment(x$1, this.outputCharset$1);
            }
            {
                this.outputCharset$1 = outputCharset$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("/");
    }

    public String decodePath(String s, Charset outputCharset) {
        return this.decodePath(s, outputCharset.name());
    }

    public AsciiBitSet play$utils$UriEncoding$$segmentChars() {
        return this.play$utils$UriEncoding$$segmentChars;
    }

    private AsciiSet pchar() {
        AsciiUnion unreserved = AsciiSet$Sets$.MODULE$.AlphaDigit().$bar$bar$bar(AsciiSet$.MODULE$.apply('-', (Seq<Object>)Predef$.MODULE$.wrapCharArray(new char[]{'.', '_', '~'})));
        AsciiSet subDelims = AsciiSet$.MODULE$.apply('!', (Seq<Object>)Predef$.MODULE$.wrapCharArray(new char[]{'$', '&', '\'', '(', ')', '*', '+', ',', ';', '='}));
        return unreserved.$bar$bar$bar(subDelims).$bar$bar$bar(AsciiSet$.MODULE$.apply(':', (Seq<Object>)Predef$.MODULE$.wrapCharArray(new char[]{'@'})));
    }

    public int play$utils$UriEncoding$$upperHex(int x) {
        return x < 10 ? x + 48 : x - 10 + 65;
    }

    private int fromHex(int b) {
        return b >= 48 && b <= 57 ? b - 48 : (b >= 65 && b <= 90 ? 10 + b - 65 : (b >= 97 && b <= 122 ? 10 + b - 97 : -1));
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> splitString(String s, char c) {
        void var3_3;
        ListBuffer result = (ListBuffer)ListBuffer$.MODULE$.empty();
        this.splitLoop$1(0, s, c, result);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final int next$1(byte[] in$1, IntRef inPos$1) {
        void var3_3;
        int b = in$1[inPos$1.elem] & 0xFF;
        ++inPos$1.elem;
        return (int)var3_3;
    }

    private final void splitLoop$1(int start, String s$1, char c$1, ListBuffer result$1) {
        block4: {
            BoxedUnit boxedUnit;
            while (start < s$1.length()) {
                int end = s$1.indexOf(c$1, start);
                if (end == -1) {
                    result$1.$plus$eq((Object)s$1.substring(start));
                    boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                result$1.$plus$eq((Object)s$1.substring(start, end));
                start = end + 1;
            }
            if (start == s$1.length()) {
                result$1.$plus$eq((Object)"");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private UriEncoding$() {
        MODULE$ = this;
        this.play$utils$UriEncoding$$segmentChars = this.pchar().toBitSet();
    }
}

